/***************************************************************************
 *   Copyright (C) 2003 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: 
///
///  AUTHOR......: Anderson Maciel
///  DATE........: Apr/24/2003
///  DESCRIPTION.: Classe implementation.
///
///////////////////////////////////////////////////////////////////

#include <general/cometimer.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

COME_Timer::COME_Timer(){

	startTime = 0.0;
	finishTime = 1.0;
	currentTime = 0.0;
	timeStep = 0.1;
}

COME_Timer::COME_Timer( double finishT, double timeS ){

	startTime = 0.0;
	finishTime = finishT;
	currentTime = 0.0;
	timeStep = timeS;
}

COME_Timer::COME_Timer( double startT, double finishT, double timeS, double currentT ){

	startTime = startT;
	finishTime = finishT;
	currentTime = currentT;
	timeStep = timeS;
}

COME_Timer::~COME_Timer(){

}

void
COME_Timer::goStep(){

	currentTime += timeStep;
}

void
COME_Timer::stepBack(){

	currentTime -= timeStep;
}

void
COME_Timer::reset(){

	currentTime = 0.0;
}

double
COME_Timer::getStart(){

	return startTime;
}

double
COME_Timer::getFinish(){

	return finishTime;
}

double
COME_Timer::getCurrent(){

	return currentTime;
}

double
COME_Timer::getStep(){

	return timeStep;
}

void
COME_Timer::setStart( double start ){

	startTime = start;
}

void
COME_Timer::setFinish( double finish ){

	finishTime = finish;
}

void
COME_Timer::setCurrent( double current ){

	currentTime = current;
}

void
COME_Timer::setStep( double step ){

	timeStep = step;
}
