/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: 
///
///  AUTHOR......: Anderson Maciel
///  DATE........: 25/July/2002
///  DESCRIPTION.: Class declaration.
///
///////////////////////////////////////////////////////////////////

#ifndef __COME_VIEW_H	
#define __COME_VIEW_H	

#include <general/come.h>
//#include <general/comescenario.h>

///////////////////////////////////////////////////////////////////
/// This abstract class is the "V" in the MVC of the COME framework
/// at VRLab. It must be implemented to provide the functionality of
/// displaying a scenario on a graphic output device.
///////////////////////////////////////////////////////////////////
class COME_View : public COME{

protected:
	
	static int	height;
	static int	width;

public:

	void	setHeight( int h );
	void	setWidth( int w );

	int		getHeight();
	int		getWidth();

	virtual	bool	update() = 0;
};

#endif // __COME_VIEW_H
