/***************************************************************************
 *   Copyright (C) 2000 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: vpat - Creating Virtual Patients
//  RESPONSIBLE.: Carla Freitas e Luciana Nedel
//
//  FILE........: vpbiaxialjoint.cpp
//  DESCRIPTION.: Contain the COME_BiaxialJoint class definitions.
//
//  AUTHOR......: Anderson Maciel
//  DATE........: January/16/2000
//  DESCRIPTION.: Methods implementation.
//
///////////////////////////////////////////////////////////////////

#include	<stdio.h>
#include	<kinematics/comebiaxialjoint.h>
#include	<kinematics/comedof.h>

COME_BiaxialJoint::COME_BiaxialJoint( void ):COME_Joint(){

	setParent( NULL );
	COME_Dof *d1 = new COME_Dof( COME_Vector3D( 0, 0, 1 ), COME_Point3D(), new COME_Bezier() );
	COME_Dof *d2 = new COME_Dof( COME_Vector3D( 1, 0, 0 ), COME_Point3D(), new COME_Bezier() );
	d1->setOwnerJoint( this );
	d2->setOwnerJoint( this );
	vpAddDof( d1 );
	vpAddDof( d2 );
	vpMakeLim();
}

COME_BiaxialJoint::COME_BiaxialJoint( COME_Joint *parent ):COME_Joint(){

	setParent( parent );
	COME_Dof *d1 = new COME_Dof( COME_Vector3D( 0, 0, 1 ), COME_Point3D(), new COME_Bezier() );
	COME_Dof *d2 = new COME_Dof( COME_Vector3D( 1, 0, 0 ), COME_Point3D(), new COME_Bezier() );
	d1->setOwnerJoint( this );
	d2->setOwnerJoint( this );
	vpAddDof( d1 );
	vpAddDof( d2 );
	vpMakeLim();
}

COME_BiaxialJoint::COME_BiaxialJoint( COME_Joint *parent, COME_Dof *dof1, COME_Dof *dof2 ):COME_Joint(){

	setParent( parent );
	dof1->setOwnerJoint( this );
	dof2->setOwnerJoint( this );
	vpAddDof( dof1 );
	vpAddDof( dof2 );
	vpMakeLim();
}

void
COME_BiaxialJoint::setFlexionTo( double value ){

	getDofList()[0]->vpMoveTo( value );
	vpMakeLim();
}

void
COME_BiaxialJoint::setAductionTo( double value ){

	getDofList()[1]->vpMoveTo( value );
	vpMakeLim();
}
