/***************************************************************************
 *   Copyright (C) 2001 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: vpat - Creating Virtual Patients
//  RESPONSIBLE.: Carla Freitas e Luciana Nedel
//
//  FILE........: vpbiaxialjoint.h
//  DESCRIPTION.: Contain the COME_BiaxialJoint class declarations.
//
//  AUTHOR......: Anderson Maciel
//  DATE........: January/15/2001
//  DESCRIPTION.: Class and new methods declaration.
//
///////////////////////////////////////////////////////////////////

#ifndef	__COME_BIAXIALJOINT_H
#define	__COME_BIAXIALJOINT_H


#include	<kinematics/comejoint.h>

/////////////////////////////////////////////////////////////////////////
// Class Name: COME_BiaxialJoint
// Superclass: COME_Joint
// Subclass: COME_CondylarJoint, COME_SaddleJoint, COME_EllipsoidJoint

class	COME_BiaxialJoint : public COME_Joint{

	private:

	public:
		COME_BiaxialJoint( void );
		COME_BiaxialJoint( COME_Joint *parent );
		COME_BiaxialJoint( COME_Joint *parent, COME_Dof *dof1, COME_Dof *dof2 );
		void	setFlexionTo( double value );
		void	setAductionTo( double value );

};

/////////////////////////////////////////////////////////////////////////
// Class Name: COME_CondylarJoint
// Superclass: COME_BiaxialJoint
// Subclass: none

class	COME_CondylarJoint : public COME_BiaxialJoint{

};

/////////////////////////////////////////////////////////////////////////
// Class Name: COME_SaddleJoint
// Superclass: COME_BiaxialJoint
// Subclass: none

class	COME_SaddlelJoint : public COME_BiaxialJoint{

};

/////////////////////////////////////////////////////////////////////////
// Class Name: COME_EllipsoidJoint
// Superclass: COME_BiaxialJoint
// Subclass: none

class	COME_EllipsoidJoint : public COME_BiaxialJoint{

};

#endif
