/***************************************************************************
 *   Copyright (C) 2001 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: 
//  RESPONSIBLE.: 
//
//  FILE........: COME_Dof.h
//  DESCRIPTION.: Contain the COME_Dof class declarations.
//
//  AUTHOR......: Anderson Maciel
//  DATE........: 23/February/2001
//  DESCRIPTION.: Class and new methods declaration.
//
///////////////////////////////////////////////////////////////////

#ifndef __COME_DOF_H
#define __COME_DOF_H

#ifndef __COME_JOINT_H
class COME_Joint;
#endif

#ifndef __COME_MODIFIER_H
class COME_Modifier;
#endif

#include	<algebra/comepoint3d.h>
#include	<algebra/comevector3d.h>
#include	<algebra/comematrix.h>
#include	<algebra/comebezier.h>
//#include	<string>
//using namespace std;


//-----------------------------------------------------------------------
// V P D O F
//-----------------------------------------------------------------------

/////////////////////////////////////////////////////////////////////////
// Class Name: COME_Dof
// Superclass: none
// Subclass: none


class COME_Dof {

	private:
		string		description;// Name of the Dof; often related to the dof's type of motion
		COME_Point3D position;		// Position of the dof related to the parent reference system
		COME_Vector3D axis;			// Arbitrary axis of rotation
		COME_Bezier	*evoluta;		// 3D path related to the axis position along its rotation
		COME_Matrix	lim;				// Local Instance Matrix
		COME_Matrix	bim;				// Base Instance Matrix
		float		minAngle;			// Min base angle in rad.
		float		maxAngle;			// Max base angle in rad.
		float		currentMinAngle;			// Min angle in rad currently valid.
		float		currentMaxAngle;			// Max angle in rad currently valid.
		float		comfortMinAngle;			// Min angle in rad for comfortable position.
		float		comfortMaxAngle;			// Max angle in rad for comfortable position.
		COME_Modifier	*rangeModifier;		// Entity used to change the motion range along motion.
		float		currentPosition;	//A real number from 0 to 1
		float		restPosition;			//Another real number from 0 to 1
		COME_Joint	*ownerJoint;			//Reference to the joint where this dof is set up
	
	protected:
		
	public:
		COME_Dof();
		COME_Dof( COME_Vector3D za, COME_Point3D pos, COME_Bezier *evol );
		COME_Dof( COME_Vector3D za, COME_Point3D pos, COME_Curve *evol,
						float min, float max, float cur, float rest );
		COME_Dof( COME_Vector3D za, COME_Point3D pos, COME_Bezier *evol,
						float min, float max, float cur, float rest, COME_Modifier *rm );
		//~COME_Dof();	
		void	setDescription( char* );
		void	setDescription( string );
		void	setComfortMin( float );
		void	setComfortMax( float );
		string			getDescription();
		COME_Vector3D	getAxis( void );
		COME_Point3D		getOrigin( void );
		COME_Point3D		getPosition( void );
		COME_Curve			getEvoluta( void );
		COME_Matrix		getLim( void );
		COME_Matrix		getBim( void );
		float				getMin( void );
		float				getMax( void );
		float				getCurrentMin( void );
		float				getCurrentMax( void );
		float				getComfortMin( void );
		float				getComfortMax( void );
		float				getCurrent( void );
		float				getRest( void );
		COME_Joint*		getOwnerJoint( void );
		void				setEvoluta( COME_Bezier *evol );
		void				setLim( COME_Matrix m );
		void				setAxis( COME_Vector3D v );
		void				setMin( float min );
		void				setMax( float max );
		void				setOwnerJoint( COME_Joint *ow );
		void				vpMoveTo( float pos );
		void				setRest( float rest );
		void				vpRest( void );
		void				setRangeModifier( COME_Modifier *m );
		COME_Modifier*	getRangeModifier( void );
		void				vpPrintLim( void );
};

#endif
