/***************************************************************************
 *   Copyright (C) 2000 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: 
//  RESPONSIBLE.: 
//
//  FILE........: vpjoint.h
//  DESCRIPTION.: Contain the COME_Joint class declarations.
//
//  AUTHOR......: Anderson Maciel
//  DATE........: August/10/2000
//  DESCRIPTION.: Class and new methods declaration.
//
///////////////////////////////////////////////////////////////////

#ifndef	__COME_JOINT_H
#define	__COME_JOINT_H


#ifndef __COME_DOF_H
class COME_Dof;
#endif

#include	<algebra/comematrix.h>
#include	<bio/comebiostructure.h>
#include	<algebra/comepoint3d.h>
#include	<algebra/comevector3d.h>
#include	<list>
#include	<string>
//using namespace std;

#define MAXDOF 6


//-----------------------------------------------------------------------
// V P J O I N T
//-----------------------------------------------------------------------

/////////////////////////////////////////////////////////////////////////
// Class Name: COME_Joint
// Superclass: none
// Subclass: COME_PlaneJoint, COME_UniaxialJoint, COME_BiaxialJoint, COME_PoliaxialJoint

class COME_Joint{

    private:
    		string		description;
				unsigned short int	numDofs;
				bool			changed;
        COME_Matrix	lim;
        COME_Matrix	invLim;
        COME_Joint*	parentJoint;
        list<COME_BioStructure*>	shapeList;
        list<COME_Joint*>			childList;
        COME_Dof** dofList;

    protected:
        void    setInvLim( COME_Matrix );

    public:
        COME_Joint();
        COME_Joint( COME_Joint * );
        COME_Joint( COME_Vector3D * );
        //~COME_Joint();

	unsigned short int	getNumDofs( void );
	void	setChanged( bool yesno );
	bool	vpIsChanged( void );
	void	setDescription( char* );
	void	setDescription( string );
	string			getDescription();
        COME_Vector3D	getVectorX( void );
        COME_Vector3D	getVectorY( void );
        COME_Vector3D	getVectorZ( void );
        COME_Joint*		getParent( void );
        list<COME_Joint*>		getChildList( void );
		list<COME_Joint*>		*getChildListPt( void );
        list<COME_BioStructure*>	getShapeList( void );
		list<COME_BioStructure*>	*getShapeListPt( void );
        COME_Dof**		getDofList( void );
        COME_Matrix		getLim( void );
        COME_Matrix		getInvLim( void );
        void	setNumDofs( unsigned short int );
        void	setParent( COME_Joint* );
        void	setChildList( list<COME_Joint*> );
        void	setLim( COME_Matrix );
        void	vpRefreshInvLim( void );
        void	vpAddShape( COME_BioStructure *shape );
        void	vpAddChild( COME_Joint *child );
        void	vpAddDof( COME_Dof *dof );
        void	vpMakeLim( void );
        void	vpPrintLim( void );
        void	vpMakeGims( COME_Matrix composite );
        //// Motion methods
        //void	setFlexionTo( float value ){ };
        //virtual void	setAductionTo( float value ){ };
        //virtual void	setTwistTo( float value ){ };

};



#endif
