/***************************************************************************
 *   Copyright (C) 2001 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: 
//  RESPONSIBLE.: 
//
//  FILE........: vpjointmotion.cpp
//  DESCRIPTION.: Contain the COME_JointMotion class definitions.
//
//  AUTHOR......: Anderson Maciel
//  DATE........: June/06/2001
//  DESCRIPTION.: Methods definition.
//
///////////////////////////////////////////////////////////////////
#include	<algebra/comevector3d.h>
#include	<stdio.h>
#include	<kinematics/comejointmotion.h>

#include	<string>
//using namespace std;


COME_JointMotion::COME_JointMotion(){

  jointName = "";
  motionType = FLEX;
  t0 = 0.0;
  tf = 0.0;
  parameter = 0.0;
  deltaS = 0.0;
}

COME_JointMotion::COME_JointMotion( string jn, int mt, float tini, float tfin, float param ){

  jointName = jn;
  motionType = mt;
  t0 = tini;
  tf = tfin;
  parameter = param;
  deltaS = 0.0;
}

COME_JointMotion::~COME_JointMotion(){
}

string
COME_JointMotion::getJointName(){
  return jointName;
}

int
COME_JointMotion::getMotionType(){
  return motionType;
}

float
COME_JointMotion::getTimeIni(){
  return t0;
}

float
COME_JointMotion::getTimeFin(){
  return tf;
}

float
COME_JointMotion::getParameter(){
  return parameter;
}

float
COME_JointMotion::getDeltaS(){
  return deltaS;
}

void
COME_JointMotion::setJointName( string s ){
  jointName = s;
}

void
COME_JointMotion::setMotionType( int mt ){
  motionType = mt;
}

void
COME_JointMotion::setTimeIni( float ti ){
  t0 = ti;
}

void
COME_JointMotion::setTimeFin( float tfin ){
  tf = tfin;
}

void
COME_JointMotion::setParameter( float param ){
  parameter = param;
}

void
COME_JointMotion::setDeltaS( float ds ){
  deltaS = ds;
}
