/***************************************************************************
 *   Copyright (C) 2001 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: 
//  RESPONSIBLE.: 
//
//  FILE........: vpmotion.h
//  DESCRIPTION.: Contain the COME_Motion class declarations.
//
//  AUTHOR......: Anderson Maciel
//  DATE........: June/06/2001
//  DESCRIPTION.: Class and new methods declaration.
//
///////////////////////////////////////////////////////////////////

#ifndef	__COME_JOINTMOTION_H
#define	__COME_JOINTMOTION_H


#include	<string>
//using namespace std;

#define FLEX    0
#define ADDUCT  1
#define TWIST   2

//-----------------------------------------------------------------------
// V P J O I N T M O T I O N
//-----------------------------------------------------------------------

/////////////////////////////////////////////////////////////////////////
// Class Name: COME_Movement
// Superclass: none
// Subclass: none

class COME_JointMotion {

  private:
    string  jointName;
    int     motionType;
    float   t0;
    float   tf;
    float   parameter;
    float   deltaS;

  public:
	  COME_JointMotion();
	  COME_JointMotion( string, int, float, float, float );
	  ~COME_JointMotion();
	
	  string  getJointName();
	  int     getMotionType();
    float   getTimeIni();
    float   getTimeFin();
    float   getParameter();
    float   getDeltaS();

    void    setJointName( string );
    void    setMotionType( int );
    void    setTimeIni( float );
    void    setTimeFin( float );
    void    setParameter( float );
    void    setDeltaS( float );
	
};

#endif
