/***************************************************************************
 *   Copyright (C) 2001 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: 
//  RESPONSIBLE.: 
//
//  FILE........: COME_Modifier.cpp
//  DESCRIPTION.: Contain the COME_Modifier class hierarchy declarations.
//
//  AUTHOR......: Anderson Maciel
//  DATE........: 28/February/2001
//  DESCRIPTION.: Classes declaration.
//
///////////////////////////////////////////////////////////////////

#include	<kinematics/comemodifier.h>
#include	<kinematics/comedof.h>
#include	<stdio.h>

COME_Modifier::COME_Modifier(){
	dofList = NULL;
	maxPonderatorList = NULL;
	minPonderatorList = NULL;
	numDofs = 0;
}


COME_Modifier::COME_Modifier( COME_Dof **dofs, COME_Curve *mins, COME_Curve *maxs, int numD ){
	dofList = dofs;
	maxPonderatorList = maxs;
	minPonderatorList = mins;
	numDofs = numD;
}


COME_Modifier::~COME_Modifier(){
	
	if( dofList != NULL ) delete [] dofList;
	if( minPonderatorList != NULL ) delete [] minPonderatorList;
	if( maxPonderatorList != NULL ) delete [] maxPonderatorList;

}

COME_Curve*
COME_Modifier::getMinPonderatorList(){
	return minPonderatorList;
}
		
COME_Curve*
COME_Modifier::getMaxPonderatorList(){
	return maxPonderatorList;
}

float
COME_Modifier::getMin(){

	float min = MINANG;
	for( int ind = 0; ind < numDofs; ind++ ){
		// Use getpointaspoit from bezier
		float aux = ( ((COME_Bezier*)&(minPonderatorList[ ind ]))->getPointAsPoint( dofList[ind]->getCurrent() ) ).getY();
		if( aux > min ) min = aux;
	}
	return min;
}


float
COME_Modifier::getMax(){

	float max = MAXANG;
	for( int ind = 0; ind < numDofs; ind++ ){
		// Use getpointaspoit from bezier
		float aux = ( ((COME_Bezier*)&(maxPonderatorList[ ind ]))->getPointAsPoint( dofList[ind]->getCurrent() ) ).getY();
		if( aux < max ) max = aux;
	}
	return max;
}

