/***************************************************************************
 *   Copyright (C) 2001 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: 
//  RESPONSIBLE.: 
//
//  FILE........: COME_Modifier.h
//  DESCRIPTION.: Contain the COME_Modifier class hierarchy declarations.
//
//  AUTHOR......: Anderson Maciel
//  DATE........: 08/February/2001
//  DESCRIPTION.: Classes declaration.
//
///////////////////////////////////////////////////////////////////

#ifndef __COME_MODIFIER_H
#define __COME_MODIFIER_H

#ifndef __COME_Dof_H
class COME_Dof;
#endif

#include	<algebra/comebezier.h>


#define MINANG -7;	// 2*(-PI) rounded
#define MAXANG 7;		// 2*PI rounded

class COME_Modifier {

	private:
		COME_Curve	*maxPonderatorList;
		COME_Curve	*minPonderatorList;
		COME_Dof		**dofList;
		int			numDofs;
		
	public:
		COME_Modifier();
		COME_Modifier( COME_Dof **dofs, COME_Curve *mins, COME_Curve *maxs, int numD );
		~COME_Modifier();
		void	setMaxList( COME_Curve *list );
		void	setMinList( COME_Curve *list );
		void	setDofList( COME_Dof **list );
		COME_Curve	*getMinPonderatorList();
		COME_Curve	*getMaxPonderatorList();
		float	getMin();
		float	getMax();
};

#endif
