/***************************************************************************
 *   Copyright (C) 2001 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: 
//  RESPONSIBLE.: 
//
//  FILE........: vpmovment.h
//  DESCRIPTION.: Contain the COME_Movement class declarations.
//
//  AUTHOR......: Anderson Maciel
//  DATE........: June/06/2001
//  DESCRIPTION.: Class and new methods declaration.
//
///////////////////////////////////////////////////////////////////

#ifndef	__COME_MOVEMENT_H
#define	__COME_MOVEMENT_H

#include	<kinematics/comejoint.h>
#include	<kinematics/comedof.h>
#include	<kinematics/comejointmotion.h>


#define INIT_TIME -0.1


//-----------------------------------------------------------------------
// V P M O V E M E N T
//-----------------------------------------------------------------------

/////////////////////////////////////////////////////////////////////////
// Class Name: COME_Movement
// Superclass: none
// Subclass: none

class COME_Movement {

  private:
    string  bodyName;
    bool    cycle;
    double   deltaT;
    double   time;
    double   tFinal;
    double   time_err;
    int     qtdMotion;

    COME_JointMotion *motionTimeline;

  public:
    COME_Movement();
	  COME_Movement( string, bool, double, double );
	  ~COME_Movement();
	
	  double         getDeltaT();
	  double         getTime();
	  double         getTimeFinal();
	  double         getTime_Err();
	  bool          getCycle();
	  int           getQtdMotion();
	  COME_JointMotion *getTimeline();
	
	  void	setTimeLine( COME_JointMotion * newTL );
	  void  setDeltaT( double );
	  void  setTime( double );
	  void  setTimeFinal( double );
	  void  setTime_Err( double );
	  void  setCycle( bool );
	  void  setQtdMotion( int );
	
	  void  vpLoadMotionFile( const char *fileName );
};

#endif
