/***************************************************************************
 *   Copyright (C) 2001 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: 
//  RESPONSIBLE.: 
//
//  FILE........: COME_PolyaxialJoint.cpp
//  DESCRIPTION.: Contain the COME_PolyaxialJoint class definitions.
//
//  AUTHOR......: Anderson Maciel
//  DATE........: May/16/2001
//  DESCRIPTION.: Methods implementation.
//
///////////////////////////////////////////////////////////////////

#include	<stdio.h>
#include	<kinematics/comepolyaxialjoint.h>
#include	<kinematics/comedof.h>

COME_PolyaxialJoint::COME_PolyaxialJoint( void ):COME_Joint(){

	setParent( NULL );
	COME_Dof *d1 = new COME_Dof( COME_Vector3D( 0, 0, 1 ), COME_Point3D(), new COME_Bezier() );
	COME_Dof *d2 = new COME_Dof( COME_Vector3D( 1, 0, 0 ), COME_Point3D(), new COME_Bezier() );
	COME_Dof *d3 = new COME_Dof( COME_Vector3D( 0, 1, 0 ), COME_Point3D(), new COME_Bezier() );
	d1->setOwnerJoint( this );
	d2->setOwnerJoint( this );
	d3->setOwnerJoint( this );
	vpAddDof( d1 );
	vpAddDof( d2 );
	vpAddDof( d3 );
	vpMakeLim();
}

COME_PolyaxialJoint::COME_PolyaxialJoint( COME_Joint *parent ):COME_Joint(){

	setParent( parent );
	COME_Dof *d1 = new COME_Dof( COME_Vector3D( 0, 0, 1 ), COME_Point3D(), new COME_Bezier() );
	COME_Dof *d2 = new COME_Dof( COME_Vector3D( 1, 0, 0 ), COME_Point3D(), new COME_Bezier() );
	COME_Dof *d3 = new COME_Dof( COME_Vector3D( 0, 1, 0 ), COME_Point3D(), new COME_Bezier() );
	d1->setOwnerJoint( this );
	d2->setOwnerJoint( this );
	d3->setOwnerJoint( this );
	vpAddDof( d1 );
	vpAddDof( d2 );
	vpAddDof( d3 );
	vpMakeLim();
}

COME_PolyaxialJoint::COME_PolyaxialJoint( COME_Joint *parent, COME_Dof *dof1, COME_Dof *dof2, COME_Dof *dof3 ):COME_Joint(){

	setParent( parent );
	dof1->setOwnerJoint( this );
	dof2->setOwnerJoint( this );
	dof3->setOwnerJoint( this );
	vpAddDof( dof1 );
	vpAddDof( dof2 );
	vpAddDof( dof3 );
	vpMakeLim();
}

void
COME_PolyaxialJoint::setFlexionTo( float value ){

	getDofList()[0]->vpMoveTo( value );
	vpMakeLim();
}

void
COME_PolyaxialJoint::setAdductionTo( float value ){

	getDofList()[1]->vpMoveTo( value );
	vpMakeLim();
}

void
COME_PolyaxialJoint::setTwistTo( float value ){

	getDofList()[2]->vpMoveTo( value );
	vpMakeLim();
}

COME_Point3D
COME_PolyaxialJoint::getCurrentAngles(){

	double currF = ( getDofList()[0]->getCurrentMin()+ ( ( getDofList()[0]->getCurrentMax() - getDofList()[0]->getCurrentMin())* getDofList()[0]->getCurrent() ) ) * 180.0 / M_PI;
	double currA = ( getDofList()[1]->getCurrentMin()+ ( ( getDofList()[1]->getCurrentMax() - getDofList()[1]->getCurrentMin())* getDofList()[1]->getCurrent() ) ) * 180.0 / M_PI;
	double currT = ( getDofList()[2]->getCurrentMin()+ ( ( getDofList()[2]->getCurrentMax() - getDofList()[2]->getCurrentMin())* getDofList()[2]->getCurrent() ) ) * 180.0 / M_PI;
	
	return COME_Point3D( currF, currA, currT );
}
