/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: 
//  RESPONSIBLE.: 
//
//  FILE........: comeuniaxialjoint.cpp
//  DESCRIPTION.: 
//
//  AUTHOR......: Anderson Maciel
//  DATE........: August/10/2000
//  DESCRIPTION.: Methods implementation.
//
///////////////////////////////////////////////////////////////////

#include	<stdio.h>
#include	<kinematics/comeuniaxialjoint.h>
#include	<kinematics/comedof.h>

COME_UniaxialJoint::COME_UniaxialJoint( void ):COME_Joint(){

	setParent( NULL );
	COME_Dof *d = new COME_Dof();
	d->setOwnerJoint( this );
	vpAddDof( d );
	vpMakeLim();
}

COME_UniaxialJoint::COME_UniaxialJoint( COME_Joint *parent ):COME_Joint(){

	setParent( parent );
	COME_Dof *d = new COME_Dof();
	d->setOwnerJoint( this );
	vpAddDof( d );
	vpMakeLim();
}

COME_UniaxialJoint::COME_UniaxialJoint( COME_Joint *parent, COME_Dof *dof1 ):COME_Joint(){

	setParent( parent );
	dof1->setOwnerJoint( this );
	vpAddDof( dof1 );
	vpMakeLim();
}

void
COME_UniaxialJoint::setFlexionTo( double value ){

	getDofList()[0]->vpMoveTo( value );
	vpMakeLim();
}
