/***************************************************************************
 *   Copyright (C) 2000 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: 
//  RESPONSIBLE.: 
//
//  FILE........: comeuniaxialjoint.h
//  DESCRIPTION.: 
//
//  AUTHOR......: Anderson Maciel
//  DATE........: August/10/2000
//  DESCRIPTION.: Class and new methods declaration.
//
///////////////////////////////////////////////////////////////////

#ifndef	__COME_UNIAXIALJOINT_H
#define	__COME_UNIAXIALJOINT_H


#include	<kinematics/comejoint.h>

/////////////////////////////////////////////////////////////////////////
// Class Name: COME_UniaxialJoint
// Superclass: COME_Joint
// Subclass: COME_PivotJoint, COME_HingeJoint

class	COME_UniaxialJoint : public COME_Joint{

	private:

	public:
		COME_UniaxialJoint( void );
		COME_UniaxialJoint( COME_Joint *parent );
		COME_UniaxialJoint( COME_Joint *parent, COME_Dof *dof1 );
		void	setFlexionTo( double value );
};

/////////////////////////////////////////////////////////////////////////
// Class Name: COME_PivotJoint
// Superclass: COME_UniaxialJoint
// Subclass: none

class	COME_PivotJoint : public COME_UniaxialJoint{

};

/////////////////////////////////////////////////////////////////////////
// Class Name: COME_HingeJoint
// Superclass: COME_UniaxialJoint
// Subclass: none

class	COME_HingeJoint : public COME_UniaxialJoint{

	
};

#endif