/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

/////////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: Anderson Maciel
///
///  AUTHOR......: Fabiana Benedetti
///  DATE........: October/2002
///  DESCRIPTION.: Class and methods declaration.
///
////////////////////////////////////////////////////////////////////

#ifndef __COMECOLLIDE_H
#define __COMECOLLIDE_H

#ifndef __COME_SCENARIO_H
class COME_Scenario;
#endif

#include <general/come.h>
#include <physics/comecollision.h>
#include <bio/comebiostructure.h>
#include <physics/comeproximity.h>


struct COME_2ndPassItem{
	
	COME_Vertex3D	*innerV;
	COME_Face	*otherF;
};


///////////////////////////////////////////////////////////////////
///   This class implements the collision detection and response methods.
///   It is strongly associated with COME_Collision, which in turn, 
///   represents a collision and all its properties.
///   Because more than one strategy is impremented to treat collisions, not all attributes
///   and functions of this class are significative at the same time.
///////////////////////////////////////////////////////////////////

class COME_Collide : public COME{

protected:
	
	vector<COME_Collision>		collisions;
	int						collisions1stLevel; // used to determine which pairs of objects potentially collide
	vector<COME_2ndPassItem>	vector2ndPass;
	
	vector<COME_Proximity>		proximityStructure;
	
public:
	
	COME_Collide( COME_Scenario* scene );	
	~COME_Collide();

	void	detectContacts();
	bool	detectContactsDisplacement();
	void	detectContacts( COME_BioStructure* organ1, COME_BioStructure* organ2 );
	void	detectContactsHybrid( COME_BioStructure* organ1, COME_BioStructure* organ2 );
	bool	detectContactsDisplacement( COME_BioStructure* organ1, COME_BioStructure* organ2 );
	void	resetCollisions();
	void	treatCollisions();

	void			setCollisions1stLevel( int detectionType );
	int			getNumberOfCollisions() const;
	vector<COME_Collision>	getCollisions() const;
	int			getCollisions1stLevel() const;
	
	bool	isNotAlreadyIn(vector<int> group, int part);
	double	findMinProjection(COME_Vector3D dir, COME_Vertex3D base, COME_Molecule* nearestMol, vector<int> faces, COME_Mesh* mesh);
	double	findMaxProjection(COME_Vector3D dir, COME_Vertex3D base, COME_Molecule* nearestMol, vector<int> faces, COME_Mesh* mesh);
	bool	IsInAcceptableRange(COME_Vector3D dir1,COME_Vector3D dir2,COME_Vertex3D base, double maxdir1,double mindir1,double maxDir2,double minDir2, COME_Face* face);
	
	void	initializeProximityStructure();
	int	addProximities( COME_Mesh *mA, COME_Mesh * mB, double hardSoft );
	void	updateProximityStructure();
	void	geometricResponse();
	void	resetProximitiesDisps();
	
	vector<COME_Proximity>*	getProximityStructurePt();
	
	void	updateVelocity( COME_Face *faceB, COME_Vertex3D *objA );
	void	sphericalSlidingResponse();
	double	signedDistance( COME_Face *faceB, COME_Point3D p, COME_Point3D pointOnB, COME_Vector3D normal );
	void	updatePosition( COME_Face *faceB, COME_Vertex3D *objA, COME_Point3D pointOnB );
	double softhard;
	
	long int CONTADIST;
};

#endif // __COMECOLLIDE_H

