/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

/////////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: Anderson Maciel
///
///  AUTHOR......: Fabiana Benedetti
///  DATE........: October/2002
///  DESCRIPTION.: Class definition.
///
////////////////////////////////////////////////////////////////////

#include <physics/comecollision.h>
#include <math.h>


//////////////////////////////////////////////////////////////////////
/// Construction/Destruction
//////////////////////////////////////////////////////////////////////
COME_Collision :: COME_Collision(){

	
}

// Fabi and Jean Version
/*COME_Collision :: COME_Collision( COME_BioStructure* organ1N, int faceInOrgan1N, COME_BioStructure* organ2N, int faceInOrgan2N ){

	organ1 = organ1N;
	organ2 = organ2N;

	faceInOrgan1 = faceInOrgan1N;
	faceInOrgan2 = faceInOrgan2N;
	
	penetrationDistance = calculatePenetrationGlobalPosition();

	//***************** Calculation of Spring constant using constant and masses **************************
	
	//double M1 = organ1->getTissue()->getMass();
	//double M2 = organ2->getTissue()->getMass();
	//springConstant = M1 < M2 ? M1 * K*2 : M2 * K*2;
	
	//***************** Calculation of Spring constant using young modulus **************************
	
	COME_Molecule* mol1 = organ1->getSurface()->getAFace( faceInOrgan1).getNearestMolecule();
	COME_Molecule* mol2 = organ2->getSurface()->getAFace( faceInOrgan2).getNearestMolecule();
	double allowedDistance = ( mol1)->getRadius() + (mol2)->getRadius();							
	springConstant = ( ( mol1->getMaterial()->getYoungsModulus()+ mol2->getMaterial()->getYoungsModulus() ) / 2 ) * allowedDistance;
	
	
	forceInFaceOrgan1 = ( organ2->getSurface()->getAFace( faceInOrgan2 ).getNormalGlobalPosition() * penetrationDistance ) * springConstant;
	forceInFaceOrgan2 = ( organ1->getSurface()->getAFace( faceInOrgan1 ).getNormalGlobalPosition() * penetrationDistance ) * springConstant;
		
}
*/

// Andi new version
COME_Collision :: COME_Collision( COME_BioStructure* organ1N, int faceInOrgan1N, COME_BioStructure* organ2N, int faceInOrgan2N ){

	organ1 = organ1N;
	organ2 = organ2N;

	faceInOrgan1 = faceInOrgan1N;
	faceInOrgan2 = faceInOrgan2N;
	
	penetrationDistance = calculatePenetrationGlobalPosition();

	//***************** Calculation of Spring constant using constant and masses **************************
	
	//double M1 = organ1->getTissue()->getMass();
	//double M2 = organ2->getTissue()->getMass();
	//springConstant = M1 < M2 ? M1 * K*2 : M2 * K*2;
	
	//***************** Calculation of Spring constant using young modulus **************************
	
	COME_Molecule* mol1 = organ1->getSurface()->getAFace( faceInOrgan1).getNearestMolecule();
	COME_Molecule* mol2 = organ2->getSurface()->getAFace( faceInOrgan2).getNearestMolecule();
	double allowedDistance =  mol1->getRadius() + mol2->getRadius();
	
	springConstant = ( ( mol1->getMaterial()->getYoungsModulus()+ mol2->getMaterial()->getYoungsModulus() ) / 2.0 ) * allowedDistance * 10;// * 100;
	
	
	forceInFaceOrgan1 = ( organ2->getSurface()->getAFace( faceInOrgan2 ).getNormalGlobalPosition() * penetrationDistance ) * springConstant;
	forceInFaceOrgan2 = ( organ1->getSurface()->getAFace( faceInOrgan1 ).getNormalGlobalPosition() * penetrationDistance ) * springConstant;
		
}


COME_Collision :: ~COME_Collision(){

	
}

//////////////////////////////////////////////////////////////////////
/// Setting
//////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////
/// Getting
//////////////////////////////////////////////////////////////////////
int
COME_Collision :: getFace( COME_BioStructure* organ ) const{

	if ( organ == organ1 ){
	
		return faceInOrgan1;
	
	}
	else{
		
		return faceInOrgan2;
	
	}
}

double		
COME_Collision :: getPenetrationDistance() const{

	return penetrationDistance;

}

double		
COME_Collision :: getSpringConst() const{

	return springConstant;

}

COME_Force	
COME_Collision :: getForceInFace( COME_BioStructure* organ ) const{

	if ( organ == organ1 ){
	
		return forceInFaceOrgan1;
	
	}
	else{
		
		return forceInFaceOrgan2;
	
	}

}
	
COME_BioStructure*		
COME_Collision :: getOrgan1(){

	return organ1;

}

COME_BioStructure*		
COME_Collision :: getOrgan2(){

	return organ2;

}


//////////////////////////////////////////////////////////////////////
/// Getting
//////////////////////////////////////////////////////////////////////
double				
COME_Collision :: calculatePenetration(){

	return (organ1->getSurface()->getAFace( faceInOrgan1 )).distanceFaceFace( organ2->getSurface()->getAFace( faceInOrgan2 ));

}

double				
COME_Collision :: calculatePenetrationGlobalPosition(){

	return organ1->getSurface()->getAFacePt(faceInOrgan1 )->distanceFaceFaceGlobalPosition( organ2->getSurface()->getAFacePt( faceInOrgan2 ));

}
