/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

/////////////////////////////////////////////////////////////////////
///
///  PROJECT.....: CO-ME
///  RESPONSIBLE.: Anderson Maciel
///
///  AUTHOR......: Fabiana Benedetti
///  DATE........: October/2002
///  DESCRIPTION.: Class and methods declaration.
///
////////////////////////////////////////////////////////////////////

#ifndef __COMECOLLISION_H	
#define __COMECOLLISION_H	

#include <general/come.h>
#include <bio/comebiostructure.h>
#include <physics/comeforce.h>

//#define K	500000
#define K	400000

///////////////////////////////////////////////////////////////////
/// This class represents a real-world collision and all its properties.
/// It stores all information about a collision between two 3D faces
///	belonging to two different organs.
///////////////////////////////////////////////////////////////////
class COME_Collision : public COME{

protected:

	COME_BioStructure*	organ1;
	COME_BioStructure*	organ2;
	int					faceInOrgan1;
	int					faceInOrgan2;
	double				penetrationDistance;
	double				springConstant;   
	COME_Force			forceInFaceOrgan1;
	COME_Force			forceInFaceOrgan2;

	double				calculatePenetration();
	double				calculatePenetrationGlobalPosition();
	
public:

	COME_Collision();
	COME_Collision( COME_BioStructure*	Organ1N, int faceInOrgan1N,
		            COME_BioStructure*	Organ2N, int faceInOrgan2N );	
	~COME_Collision();

	int					getFace( COME_BioStructure* organ ) const;
	double				getPenetrationDistance() const;
	double				getSpringConst() const;
	COME_Force			getForceInFace( COME_BioStructure* organ ) const;
	COME_BioStructure*	getOrgan1();
	COME_BioStructure*	getOrgan2();
	
};

#endif // __COMECOLLISION_H
