/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: CO-ME
//  RESPONSIBLE.: 
//
//  FILE........: comeforce.cpp
//  DESCRIPTION.: 
//				   
//
//  AUTHOR......: Anderson Maciel
//  DATE........: Jun/04/2002
//  DESCRIPTION.: Class definition.
//
///////////////////////////////////////////////////////////////////

#include <physics/comeforce.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

COME_Force::COME_Force(){

	force = COME_Vector3D( 0, 0, 0 );
}

COME_Force::COME_Force( double x, double y, double z ){

	force = COME_Vector3D( x, y, z );
}

COME_Force::COME_Force( const COME_Vector3D& vectorN ){

	force = COME_Vector3D( vectorN );
}

COME_Force::COME_Force( COME_Point3D& pointN ){

	force = COME_Vector3D( pointN.getX(), pointN.getY(), pointN.getZ() );
}

COME_Force::~COME_Force()
{

}

void
COME_Force::setIntensity( float intensityN ){

	force.vpNormalize();
	force = force*intensityN;
}

void
COME_Force::setDirection( COME_Vector3D &directionN ){
	
	double module = getIntensity();
	directionN.vpNormalize();
	directionN = directionN*module;
}

void
COME_Force::setForceVector( COME_Vector3D &vectorN ){
	
	force.setXYZ( vectorN.getX(), vectorN.getY(), vectorN.getZ() );
}

double
COME_Force::getIntensity(){

	return force.vpModule();
}

COME_Vector3D*
COME_Force::getDirection() const {

	COME_Vector3D* forceN = new COME_Vector3D( force );
	forceN->vpNormalize();
	return forceN;
}


COME_Vector3D
COME_Force::getForceVector() const{

	return force;
}

COME_Force
COME_Force::operator+ (const COME_Force& f) {
 
	COME_Force ff( force + f.getForceVector() );
	return ( ff ) ;
} 

COME_Force
COME_Force::operator- (const COME_Force& f) {
 
	COME_Force ff( force - f.getForceVector() );
	return ( ff ) ;
}

COME_Force
COME_Force::operator/ ( const double& f ) {
      COME_Force ff( force.getX() / f, force.getY() / f, force.getZ() / f );
      return ( ff ) ;
}