/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: CO-ME
//  RESPONSIBLE.: 
//
//  FILE........: comeforce.h
//  DESCRIPTION.: 
//				   
//
//  AUTHOR......: Anderson Maciel
//  DATE........: Jun/04/2002
//  DESCRIPTION.: Class declaration.
//
///////////////////////////////////////////////////////////////////

#ifndef __COME_FORCE_H	
#define __COME_FORCE_H	


#include <general/come.h>
#include <algebra/comevector3d.h>

class COME_Force : public COME {

protected:
	COME_Vector3D	force;

public:
	COME_Force();
	COME_Force( double x, double y, double z );
	COME_Force( const COME_Vector3D& vectorN );
	COME_Force( COME_Point3D& pointN );
	virtual ~COME_Force();

	void	setIntensity( float intensityN );
	void	setDirection( COME_Vector3D &directionN );
	void	setForceVector( COME_Vector3D &vectorN );
	
	double				getIntensity();
	COME_Vector3D*			getDirection() const;
	COME_Vector3D			getForceVector() const;

	COME_Force	operator+ ( const COME_Force& f );
	COME_Force	operator- ( const COME_Force& f );
	COME_Force	operator/ ( const double& f );
};

#endif // __COME_FORCE_H	


