/***************************************************************************
 *   Copyright (C) 2004 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#include	<physics/comeproximity.h>
#include	<bio/comemolecule.h>

#include	<math.h>

COME_Proximity::COME_Proximity( COME_Vertex3D *oA, COME_Vertex3D * oB ){
 
 	//objA = oA;
	//objB = oB;
	
}

COME_Proximity::COME_Proximity( COME_Vertex3D *oA, COME_Face * fB, double hardSoftP ){
 
	objA = oA;
	faceB = fB;
	hardSoft = hardSoftP;
	
	// Calculate point on B
	//pointOnB = faceB->getCenterGlobalPosition();
	pointOnB = faceB->getClosestPointOnFaceToPoint( COME_Point3D( objA->x, objA->y, objA->z ) );
	//COME_Vertex3D *vvP = faceB->getClosestVertexPt( COME_Point3D( objA->x, objA->y, objA->z ) );
	//pointOnB =COME_Point3D( vvP->x, vvP->y, vvP->z );
}
 
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// 
void
COME_Proximity::updatePointOnFace(){
 
	//pointOnB = faceB->getCenterGlobalPosition();
	pointOnB = faceB->getClosestPointOnFaceToPoint( COME_Point3D( objA->x, objA->y, objA->z ) );
 	
 }
 
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// Returns the distance of this proximity. Distance is negative if a penetration occurs.
double
COME_Proximity::signedDistance(){
 
	COME_Vector3D p_a = objA->getVertexAsPoint3D() - COME_Vector3D( faceB->getVertexGlobalPositionPt( 0 )->x, faceB->getVertexGlobalPositionPt( 0 )->y, faceB->getVertexGlobalPositionPt( 0 )->z );
	double dist = pointOnB.vpDistance( objA->getVertexAsPoint3D() );
	
	/*double signal = faceB->getNormalGlobalPosition().vpDotProduct( p_a );
	if( signal < 0.0 ) {
		dist = -dist;
	}*/
	
	if( ( faceB->getNormalGlobalPositionPt()->vpDotProduct( objA->getNormalGlobalPosition() ) < 0.0 ) && ( faceB->isInsideGlobalGOOD( objA->getVertexAsPoint3D() ) ) )
		dist = -dist;
	
	return dist;
	
 }
 
 ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// Returns the distance of the point given to the face (faceB) of this proximity. Distance is negative if a penetration occurs.
double
COME_Proximity::signedDistance( COME_Point3D p ){
 
	COME_Vector3D p_a = p - COME_Vector3D( faceB->getVertexGlobalPositionPt( 0 )->x, faceB->getVertexGlobalPositionPt( 0 )->y, faceB->getVertexGlobalPositionPt( 0 )->z );
	double dist = pointOnB.vpDistance( p );
	
	
	/*double signal = faceB->getNormalGlobalPosition().vpDotProduct( p_a );
	if( signal < 0.0 ) {
		dist = -dist;
	}*/
	
	if( ( faceB->getNormalGlobalPositionPt()->vpDotProduct( objA->getNormalGlobalPosition() ) < 0.0 ) && ( faceB->isInsideGlobalGOOD( p ) ) )
		dist = -dist;
	
	return dist;
 }

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// Calculate position update for this proximity members when needed.
/// Use barycentric coordinates to define weights for faceB vertices.
void
COME_Proximity::updatePosition(){

	COME_Vector3D posCorrection = pointOnB - objA->getVertexAsPoint3D();
	
	// update objA
	objA->addCollisionDisp( posCorrection/hardSoft );
	
	// update faceB
	COME_Vertex3D *A =  faceB->getVertexGlobalPositionPt( 0 );
	COME_Vertex3D *B =  faceB->getVertexGlobalPositionPt( 1 );
	COME_Vertex3D *C =  faceB->getVertexGlobalPositionPt( 2 );
	
	A->addCollisionDisp( -posCorrection/hardSoft );
	B->addCollisionDisp( -posCorrection/hardSoft );
	C->addCollisionDisp( -posCorrection/hardSoft );

}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// Calculate velocity update for this proximity members when needed
void
COME_Proximity::updateVelocity(){

	COME_Vector3D velocDir;
	if( !(signedDistance() < 0) ){
		velocDir = objA->getVertexAsPoint3D() - pointOnB; velocDir.vpNormalize();
	
		COME_Vector3D velocA = objA->getBlendedVelocity();
		COME_Vector3D velocB = faceB->getBlendedVelocity( pointOnB );
		COME_Vector3D velocRelativeA = velocDir * COME_Vector3D(velocA-velocB).vpDotProduct(velocDir);
		
		COME_Point3D posObjATimePlusOne = objA->getVertexAsPoint3D() + ( velocRelativeA * COME::timestepGlobal * 1.0 );
		
		if( signedDistance( posObjATimePlusOne ) < 0.0 ){
			
			COME_Vector3D velocCorrection = velocRelativeA - ( ( pointOnB - objA->getVertexAsPoint3D() ) * ( 1.0 / ( COME::timestepGlobal * 1.0 ) ) );
			
			// update objA
			objA->addVelocityDisp( -velocCorrection/hardSoft );
			
			// update faceB
			COME_Vertex3D *A =  faceB->getVertexGlobalPositionPt( 0 );
			COME_Vertex3D *B =  faceB->getVertexGlobalPositionPt( 1 );
			COME_Vertex3D *C =  faceB->getVertexGlobalPositionPt( 2 );
			
			A->addVelocityDisp( velocCorrection/hardSoft );
			B->addVelocityDisp( velocCorrection/hardSoft );
			C->addVelocityDisp( velocCorrection/hardSoft );
		}
	} else {
		updatePosition();
		objA->addVelocityDisp( -objA->getBlendedVelocity() );
		faceB->getVertexGlobalPositionPt( 0 )->addVelocityDisp( -faceB->getVertexGlobalPositionPt( 0 )->getBlendedVelocity() );
		faceB->getVertexGlobalPositionPt( 1 )->addVelocityDisp( -faceB->getVertexGlobalPositionPt( 1 )->getBlendedVelocity() );
		faceB->getVertexGlobalPositionPt( 2 )->addVelocityDisp( -faceB->getVertexGlobalPositionPt( 2 )->getBlendedVelocity() );
	}
	
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// Reset the velocity and position displacements for the anchors of this proximity
void
COME_Proximity::resetDisplacements(){

	// reset position displacements
	objA->setCollisionDisp( COME_Vector3D() );
	faceB->getVertexGlobalPositionPt( 0 )->setCollisionDisp( COME_Vector3D() );
	faceB->getVertexGlobalPositionPt( 1 )->setCollisionDisp( COME_Vector3D() );
	faceB->getVertexGlobalPositionPt( 2 )->setCollisionDisp( COME_Vector3D() );
	
	// reset velocity displacements
	objA->setVelocityDisp( COME_Vector3D() );
	faceB->getVertexGlobalPositionPt( 0 )->setVelocityDisp( COME_Vector3D() );
	faceB->getVertexGlobalPositionPt( 1 )->setVelocityDisp( COME_Vector3D() );
	faceB->getVertexGlobalPositionPt( 2 )->setVelocityDisp( COME_Vector3D() );
	
	// reset anchors 
	int j;
	vector<COME_Molecule*> localAnchors = objA->getAnchors();
	for( j = 0; j < localAnchors.size(); j++ ){
		localAnchors[j]->setUpdated(false);
	}
	localAnchors = faceB->getVertexGlobalPositionPt( 0 )->getAnchors();
	for( j = 0; j < localAnchors.size(); j++ ){
		localAnchors[j]->setUpdated(false);
	}
	localAnchors = faceB->getVertexGlobalPositionPt( 1 )->getAnchors();
	for( j = 0; j < localAnchors.size(); j++ ){
		localAnchors[j]->setUpdated(false);
	}
	localAnchors = faceB->getVertexGlobalPositionPt( 2 )->getAnchors();
	for( j = 0; j < localAnchors.size(); j++ ){
		localAnchors[j]->setUpdated(false);
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// Update velocity and position of anchors of this proximity (vertex objA and al vertices of objB) taking all buois displacements into account
/// ************** THERE'S A BUG HERE!! ALL DISPLACEMENTS ARE CALCULATED FROM GLOBAL MOLECULES POSITIONS
/// ************** AND APPLIED ONTO LOCAL COORDINATES...
void
COME_Proximity::updateAnchors(){ /// DEPRECATED

	// Update anchors of objA
	vector<COME_Molecule*> localAnchors = objA->getAnchors();
	for( int j = 0; j < localAnchors.size(); j++ ){

		if( ( ! localAnchors[j]->isFixed() ) && ( ! localAnchors[j]->isUpdated() ) ){
		
			vector<COME_Vertex3D*> *vertices = localAnchors[j]->getBuois();
			int i;
			double sumDists = 0.0;
			int count = 1;
			for( i = 0; i < vertices->size(); i++ ){
				sumDists += pow( (*vertices)[i]->vpDistance( localAnchors[j]->getGlobalPosition() ), 2.0 );
			}
			
			count = i-1;
			if( count == 0 ) count = 1;
			
			COME_Vector3D dispPosition;
			COME_Vector3D dispVelocity;
			for( i = 0; i < vertices->size(); i++ ){
				//double w = ( 1.0 - ( pow( (*vertices)[i]->vpDistance( localAnchors[j]->getGlobalPosition() ), 2.0 ) / sumDists ) ) / (count*2.0);
				//dispPosition =  dispPosition + ( (*vertices)[i]->getCollisionDispAvg() * w );
				//dispVelocity =  dispVelocity + ( (*vertices)[i]->getVelocityDispAvg() * w );
				if( dispPosition.vpModule() < ( (*vertices)[i]->getCollisionDispAvg().vpModule()  ) )
					dispPosition = ( (*vertices)[i]->getCollisionDispAvg()  );
				if( dispVelocity.vpModule() < ( (*vertices)[i]->getVelocityDispAvg().vpModule() ) )
					dispVelocity = ( (*vertices)[i]->getVelocityDispAvg() );
			}
			
			COME_Point3D newPos = localAnchors[j]->getPosition() + dispPosition;
			COME_Vector3D newVeloc = localAnchors[j]->getVelocity() + dispVelocity;
			//localAnchors[j]->setPosition( newPos );
				
			//printf( "dispVelocityonAnchor: %f %f %f newVelocityonAnchor: %f %f %f \n", dispVelocity.x, dispVelocity.y, dispVelocity.z, newVeloc.x, newVeloc.y, newVeloc.z );
			//localAnchors[j]->setVelocity( newVeloc );
			localAnchors[j]->setUpdated(true);
		}
	}
	
	// Update anchors of objB
	for( int oBi = 0; oBi < 3; oBi++ ){
		localAnchors = faceB->getVertexGlobalPositionPt( oBi )->getAnchors();
		for( int jB = 0; jB < localAnchors.size(); jB++ ){
	
			if( ( ! localAnchors[jB]->isFixed() ) && ( ! localAnchors[jB]->isUpdated() ) ){
			
				vector<COME_Vertex3D*> *vertices = localAnchors[jB]->getBuois();
				int i;
				double sumDists = 0.0;
				int count = 1;
				for( i = 0; i < vertices->size(); i++ ){
					sumDists += pow( (*vertices)[i]->vpDistance( localAnchors[jB]->getGlobalPosition() ), 2.0 );
				}
				
				count = i-1;
				if( count == 0 ) count = 1;
				
				COME_Vector3D dispPosition;
				COME_Vector3D dispVelocity;
				for( i = 0; i < vertices->size(); i++ ){
					//double w = ( 1.0 - ( pow( (*vertices)[i]->vpDistance( localAnchors[jB]->getGlobalPosition() ), 2.0 ) / sumDists ) ) / (count*2.0);
					//dispPosition =  dispPosition +  ( (*vertices)[i]->getCollisionDispAvg() * w );
					//dispVelocity =  dispVelocity +   ( (*vertices)[i]->getVelocityDispAvg() * w );
					if( dispPosition.vpModule() < ( (*vertices)[i]->getCollisionDispAvg().vpModule()  ) )
						dispPosition = ( (*vertices)[i]->getCollisionDispAvg()  );
					if( dispVelocity.vpModule() < ( (*vertices)[i]->getVelocityDispAvg().vpModule() ) )
						dispVelocity = ( (*vertices)[i]->getVelocityDispAvg() );
				}
				COME_Point3D newPos = localAnchors[jB]->getPosition() + dispPosition;
				COME_Vector3D newVeloc = localAnchors[jB]->getVelocity() + dispVelocity;
				//localAnchors[jB]->setPosition( newPos );
				//printf( "dispPos2onAnchor: %f %f %f newPos2onAnchor: %f %f %f \n", dispPosition.x, dispPosition.y, dispPosition.z, newPos.x, newPos.y, newPos.z );
				//localAnchors[jB]->setVelocity( newVeloc );
				localAnchors[jB]->setUpdated(true);
			}
		}
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// Update velocity and position of anchors of this proximity (vertex objA and al vertices of objB) taking all buois displacements into account
/// This function uses a Jacobian matrix for optimization as in an Inverse Kinematics problem.
void
COME_Proximity::updateAnchorsOptimization(){

	// fill big arrays of positions and velocities
	// multiply J by the arrays
	// apply result onto molecules.

}
