/***************************************************************************
 *   Copyright (C) 2004 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include	<algebra/comevertex3d.h>
#include	<algebra/comeface.h>

#define	HARD	1.0
#define	SOFT	2.0
 
 class COME_Proximity{
 
 	private:
 
	public: 
	
	COME_Vertex3D	*objA;
	//COME_Vertex3D	*objB;
	COME_Face		*faceB;
	COME_Point3D		pointOnB;
	double			hardSoft;
	
	COME_Proximity( COME_Vertex3D *oA, COME_Vertex3D * oB );
	COME_Proximity( COME_Vertex3D *oA, COME_Face * fB, double hardSoftP );
	
	void		updatePointOnFace();
	double	signedDistance();
	double	signedDistance( COME_Point3D p );
	
	void	updatePosition();
	void	updateVelocity();
	void	resetDisplacements();
	void	updateAnchors();
	void	updateAnchorsOptimization();
 
 };
