/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: CO-ME
//  RESPONSIBLE.: 
//
//  FILE........: cometimeforce.cpp
//  DESCRIPTION.: 
//				   
//
//  AUTHOR......: Anderson Maciel
//  DATE........: Oct/01/2002
//  DESCRIPTION.: Class definition.
//
///////////////////////////////////////////////////////////////////

#include <physics/cometimeforce.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

COME_TimeForce::COME_TimeForce(){

	force = COME_Vector3D( 0, 0, 0 );
	time = 0.0;
}

COME_TimeForce::COME_TimeForce( double x, double y, double z, double t ){

	force = COME_Vector3D( x, y, z );
	time = t;
}

COME_TimeForce::COME_TimeForce( const COME_Vector3D& vectorN, double t ){

	force = COME_Vector3D( vectorN );
	time = t;
}

COME_TimeForce::COME_TimeForce( COME_Point3D& pointN, double t ){

	force = COME_Vector3D( pointN.getX(), pointN.getY(), pointN.getZ() );
	time = t;
}

COME_TimeForce::~COME_TimeForce()
{

}

void
COME_TimeForce::setTime( double t ){

	time = t;
}

double
COME_TimeForce::getTime() const {

	return time;
}

