/***************************************************************************
 *   Copyright (C) 2002 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/

///////////////////////////////////////////////////////////////////
//
//  PROJECT.....: CO-ME
//  RESPONSIBLE.: 
//
//  FILE........: cometimeforce.h
//  DESCRIPTION.: 
//				   
//
//  AUTHOR......: Anderson Maciel
//  DATE........: Oct/01/2002
//  DESCRIPTION.: Class declaration.
//
///////////////////////////////////////////////////////////////////

#ifndef __COME_TIMEFORCE_H	
#define __COME_TIMEFORCE_H	


#include <general/come.h>
#include <physics/comeforce.h>

class COME_TimeForce : public COME_Force {

protected:
	double	time;

public:
	COME_TimeForce();
	COME_TimeForce( double x, double y, double z, double t );
	COME_TimeForce( const COME_Vector3D& vectorN, double t );
	COME_TimeForce( COME_Point3D& pointN, double t );
	virtual ~COME_TimeForce();

	void	setTime( double t );
	
	double	getTime() const;
};

#endif // __COME_TIMEFORCE_H	


