/***************************************************************************
 *   Copyright (C) 2004 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <comeqglwidget.h>
#include <general/comescenario.h>
#include <algebra/comemesh.h>
#include <algebra/comeface.h>
#include <bio/comebiostructure.h>
#include <bio/comemoleculescartilage.h>
//#include <comediscretizer.h>
#include <qcheckbox.h>
#include <qtimer.h>
#include <qcursor.h>
#include <qslider.h>
#include <qpopupmenu.h>
#include <qspinbox.h>
#include <qstatusbar.h>
#include <GL/glut.h>



#ifdef GPU_FORCES
	
	#include <Cg/cg.h>
	#include <Cg/cgGL.h>

	// Global variables: hold the Cg context that we're storing our programs
	// in as well as handles to the vertex and fragment program used in this
	// demo.
	
	CGcontext context;
	CGprogram vertexProgram, fragmentProgram;
	
	// Choose the vertex and fragment profiles to use.  Try to use
	// CG_PROFILE_ARBVFP1 and CG_PROFILE_ARBFP1, depending on hardware support.
	// If those aren't available, fall back to CG_PROFILE_VP30 and
	// CG_PROFILE_FP30, respectively.
	
	CGprofile vertexProfile, fragmentProfile;
		
#endif


COME_QGLWidget::COME_QGLWidget( QWidget *parent, const char *name ):QGLViewer(parent, name){
	
	Timer = new QTimer( this, "Timer" );
	scene = NULL;
	wireframe_ = false;
	flatShading_ = false;
	connect( Timer, SIGNAL( timeout() ), SLOT( updateGL() ) );
}
   
void
COME_QGLWidget::startTimer( int msec ){
    
    Timer->start( msec, false );
}

void
COME_QGLWidget::setScene( COME_Scenario *sc ){
    
    scene = sc;
}

void
COME_QGLWidget::setGlobal( COME *global1 ){
    
	global = global1;
}

COME*
COME_QGLWidget::getGlobal(){

	return global;
}

void
COME_QGLWidget::draw(){

	//CGparameter 
	//cgGLSetParameter3fv(cgGetNamedParameter(fragmentProgram, "lightColor"), lightColor);
	
	
	if( scene ){
		glPushMatrix();
			glTranslatef( 10, 0, 0  );
			glutSolidSphere(1, 15, 15);
		glPopMatrix();
		glPushMatrix();
			glTranslatef( 20, 0, 0  );
			glutSolidSphere(1, 15, 15);
		glPopMatrix();

	}
}
	

void
COME_QGLWidget::init(){

	// Restore previous viewer state.
	restoreStateFromFile();
	
	setSceneRadius(1.0);  // for instance 
	//setSceneCenter(0,0,0); // for instance
	camera()->showEntireScene();

	// Set 'Control' as the FPS toggle state key (default was 'F' and becomes 'CTRL+F')
	//setShortcutStateKey(QGLViewer::DISPLAY_FPS, Qt::ControlButton);
	
	#ifdef GPU_FORCES
		// Basic Cg setup; create an initial context
		context = cgCreateContext();
		
		// setup profile
		if (cgGLIsProfileSupported(CG_PROFILE_ARBFP1))
		fragmentProfile = CG_PROFILE_ARBFP1;
		else {
			// try FP30
			if (cgGLIsProfileSupported(CG_PROFILE_FP30))
			fragmentProfile = CG_PROFILE_FP30;
			else {
			fprintf(stderr, "Neither arbfp1 or fp30 fragment profiles supported on this system.\n");
			exit(1);
			}
		}
		// Load CG program
		LoadCgPrograms();
	#endif
	
	// Display the help window. The help window tabs are automatically updated when you define new
	// standard key or mouse bindings (as is done above). Use shortcutBindingsString() and
	// mouseBindingsString() to add the description of your own new actions.
	//help();
}

///////////////////////////////////////////////
//      Define new key bindings : F & W      //
///////////////////////////////////////////////

void
COME_QGLWidget::keyPressEvent(QKeyEvent *e){

  // Get event state key
  const Qt::ButtonState state = (Qt::ButtonState)(e->state() & Qt::KeyButtonMask);
  // Bug in Qt : use 0x0f00 instead of Qt::KeyButtonMask with Qt versions < 3.1

  // A simple switch on e->key() is not sufficient if we want to take state key into account.
  // With a switch, it would have been impossible to separate 'F' from 'CTRL+F'.
  // That's why we use imbricated if...else and a "handled" boolean.
  bool handled = false;
  if ((e->key()==Qt::Key_W) && (state==Qt::NoButton))
    {
      wireframe_ = !wireframe_;
      if (wireframe_){
	glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
      } else {
	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
	}
      handled = true;
      updateGL();
    }
  else
    if ((e->key()==Qt::Key_Q) && (state==Qt::NoButton))
      {
	flatShading_ = !flatShading_;
	if (flatShading_)
	  glShadeModel(GL_FLAT);
	else
	  glShadeModel(GL_SMOOTH);
	handled = true;
	updateGL();
      }
  // and so on with other else if.

  if (!handled){
    QGLViewer::keyPressEvent(e);
   }
}


QString
COME_QGLWidget::helpString() const
{
  QString text("<h2>VRlab - COME 3D Viewer</h2>");
  text += "Copyright (C) 2004 by Anderson Maciel<br>";
  text += "andi.maciel@gmail.com <br><br>";
  text += "This program is free software; you can redistribute it and/or modify ";
  text += "it under the terms of the GNU General Public License as published by ";
  text += "the Free Software Foundation; either version 2 of the License, or ";
  text += "(at your option) any later version. <br><br>";
  text += "This program is distributed in the hope that it will be useful, ";
  text += "but WITHOUT ANY WARRANTY; without even the implied warranty of ";
  text += "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the ";
  text += "GNU General Public License for more details. <br><br>";
  text += "You should have received a copy of the GNU General Public License ";
  text += "along with this program; if not, write to the ";
  text += "Free Software Foundation, Inc., ";
  text += "59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.";

  text += "<h3>Basic instructions:</h3> ";
  text += "Use the mouse to move the camera around the object. ";
  text += "You can revolve around, zoom and translate with the three buttons. ";
  text += "Left and middle buttons pressed together rotate around the camera z axis<br><br>";
  text += "Pressing <b>Alt</b> and one of the function key (<b>F1</b>..<b>F12</b>) defines a camera keyFrame. ";
  text += "Simply press the function key again to restore it. Several keyFrames define a ";
  text += "camera path. Paths are saved when you quit the application.<br><br>";
  text += "Press <b>W</b> to switch between wireframe and filled polygons, <b>Q</b> to switch between flat and smooth shading, <b>A</b> for the world axis, ";
  text += "<b>Alt+Return</b> for full screen mode and <b>Control+S</b> to save a snapshot.<br><br>";
  text += "A double click aligns the closer axis with the camera (left, if close enough), fits ";
  text += "the zoom of the camera (middle) or re-center the scene (right).<br>";
  text += "A left double click while right button is pressed defines the <i>revolveAroundPoint</i>.";
  text += "With middle button pressed instead, it zooms on the pixel.<br><br>";
  text += "See also the <b>Shortcuts</b> and <b>Mouse</b> tabs and the documentation web pages.<br>";
  text += "Press <b>Escape</b> to exit the viewer.";
  return text;
}

void
COME_QGLWidget::drawCylinder(){

	GLUquadricObj *qobj;
	qobj = gluNewQuadric();
	glPushMatrix();
		glRotatef( -90, 1, 0, 0 ); 
		gluCylinder( qobj, 1, 1, 1, 8, 4 );
	glPopMatrix();
	gluDeleteQuadric(qobj);
}

static void
LoadCgPrograms() {

	#ifdef GPU_FORCES    
		//assert(cgIsContext(context));
	
		// And similarly set things up for the fragment program.
		fragmentProgram = cgCreateProgramFromFile(context, CG_SOURCE, CWD "calculate_forces.cg",
						fragmentProfile, NULL, NULL);
		if (!cgIsProgramCompiled(fragmentProgram))
			cgCompileProgram(fragmentProgram);
	
		cgGLEnableProfile(fragmentProfile);
		cgGLLoadProgram(fragmentProgram);
	#endif
}
