/***************************************************************************
 *   Copyright (C) 2004 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qgl.h>
#include <QGLViewer/qglviewer.h>
#include <general/come.h>

#define MAX_LINES 10000000

class QTimer;
class COME_Scenario;
class COME_Discretizer;
 
class COME_QGLWidget: public QGLViewer {

	Q_OBJECT        // must include this if you use Qt signals/slots

	public:
		COME_QGLWidget( QWidget *parent, const char *name );
		
		void startTimer( int msec );
		void setScene( COME_Scenario *sc );
		void setGlobal( COME *global1 );
		
		COME* getGlobal();

	protected:
	
		COME_Scenario	*scene;
	
		virtual void draw();
		virtual void init();
		virtual void keyPressEvent(QKeyEvent *e);
		virtual QString helpString() const;
	
	private:
		QTimer *Timer;
		COME *global;
		bool wireframe_, flatShading_;
		
		void drawCylinder();
};
