/***************************************************************************
 *   Copyright (C) 2004 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <come_discretizerqglwidget.h>
#include <comediscretizer.h>
#include <general/comescenario.h>
#include <general/comesimulator.h>
#include <qcheckbox.h>
#include <qtimer.h>
#include <qcursor.h>
#include <qslider.h>
#include <qpopupmenu.h>
#include <qspinbox.h>
#include <qstatusbar.h>
#include <GL/glut.h>

double oldClock;

COME_DiscretizerQGLWidget::COME_DiscretizerQGLWidget( QWidget *parent, const char *name )
 : COME_QGLWidget( parent, name )
{
	oldClock = 0.0;
}


COME_DiscretizerQGLWidget::~COME_DiscretizerQGLWidget()
{
}

void
COME_DiscretizerQGLWidget::draw(){

	//CGparameter 
	//cgGLSetParameter3fv(cgGetNamedParameter(fragmentProgram, "lightColor"), lightColor);
	glPushMatrix();
			glTranslatef( 5, 0, 0  );
			glutSolidSphere(1, 4, 4);
		glPopMatrix();
	
	if( scene ){
		glPushMatrix();
			glTranslatef( 10, 0, 0  );
			glutSolidSphere(1, 15, 15);
		glPopMatrix();
		glPushMatrix();
			glTranslatef( 20, 0, 0  );
			glutSolidSphere(1, 15, 15);
		glPopMatrix();
		
		scene->lock();

		//Main loop: For each organ display the object
		int sphereName = 0;
		list<COME_BioStructure*>::const_iterator iterOrgans;
		for( iterOrgans = ((list<COME_BioStructure *>*)scene->getPatient(0)->getPtOrganList())->begin(); iterOrgans != ((list<COME_BioStructure *>*)scene->getPatient(0)->getPtOrganList())->end(); iterOrgans++  ){
			list<COME_Molecule*>::const_iterator iterCells;
		
			//Draw the Sphere Model			
			if (((COME_Discretizer*)getGlobal())->cbSpheres->isChecked()){
				for ( iterCells = (*iterOrgans)->getTissue()->getShape()->begin(); iterCells != (*iterOrgans)->getTissue()->getShape()->end(); iterCells++ ){
					
					COME_Point3D position = (*iterCells)->getGlobalPosition();
					glPushName(sphereName++);
					glPushMatrix();
						glTranslatef(position.getX(),position.getY(),position.getZ());

						if( !(*iterCells)->isFixed() ){
							glColor3f((*iterCells)->getMaterial()->getColor().getPointAsArray()[0],(*iterCells)->getMaterial()->getColor().getPointAsArray()[1],(*iterCells)->getMaterial()->getColor().getPointAsArray()[2]);	
						} else if( (*iterCells)->getDescription() == "origin" ){
							glColor3f((*iterCells)->getMaterial()->getColor().getPointAsArray()[0]*2.0,(*iterCells)->getMaterial()->getColor().getPointAsArray()[1]*2.0,(*iterCells)->getMaterial()->getColor().getPointAsArray()[2]*2.0);
						} else {
							glColor3f((*iterCells)->getMaterial()->getColor().getPointAsArray()[0]*0.2,(*iterCells)->getMaterial()->getColor().getPointAsArray()[1]*0.2,(*iterCells)->getMaterial()->getColor().getPointAsArray()[2]*0.2);
						}
						
						glutSolidSphere((*iterCells)->getRadius()*((double)((COME_Discretizer*)getGlobal())->sliderScale->value()/100.0), 15, 15);
					glPopMatrix();
					glPopName();
					
					if( ((COME_Discretizer*)getGlobal())->cbLinks->isChecked() ){
						list<COME_MoleculeLink*>::iterator iterThis;
						for(iterThis = (*iterCells)->getConnectionList()->begin(); !( iterThis == (*iterCells)->getConnectionList()->end() ); iterThis++){
							COME_Point3D position2 = (*iterThis)->getOtherElement((*iterCells))->getGlobalPosition();
							glBegin(GL_LINES);
								glColor3f(0.9,0.9,0.9);
								glVertex3f(position.getX(),position.getY(),position.getZ());
								glVertex3f(position2.getX(),position2.getY(),position2.getZ());
							glEnd();
						}
					}
				}
			}

			// Draw a grid according to GUI parameters
			if (((COME_Discretizer*)getGlobal())->cbGrid->isChecked()){
				
				double dist = ((double)((COME_Discretizer*)getGlobal())->sbDistance->value())/1000.0;
				COME_Point3D mins, maxs;
				COME_Mesh* mesh = (*iterOrgans)->getPointerToSurface();
				mesh->getEnvelop( mins, maxs );
			
				if( ( ( ( maxs.getX()-mins.getX() ) * ( maxs.getY()-mins.getY() ) * ( maxs.getZ()-mins.getZ() ) ) / dist ) > MAX_LINES ){
					((COME_Discretizer*)getGlobal())->statusBar()->message( "Grid too dense. Please increase preferred distance to avoid overload.", 500 );
				} else {
					for( double xMgrid = mins.getX(); xMgrid <= maxs.getX(); xMgrid += dist ){
						for( double yMgrid = mins.getY(); yMgrid <= maxs.getY(); yMgrid += dist ){
							glBegin(GL_LINES);
								glColor3f(0.5,0.5,0.5);
								glVertex3f(xMgrid, yMgrid, mins.getZ());
								glVertex3f(xMgrid, yMgrid, maxs.getZ());
							glEnd();
						}
						for( double zMgrid = mins.getZ(); zMgrid <= maxs.getZ(); zMgrid += dist ){
							glBegin(GL_LINES);
								glColor3f(0.9,0.9,0.9);
								glVertex3f(xMgrid, mins.getY(), zMgrid);
								glVertex3f(xMgrid, maxs.getY(), zMgrid);
							glEnd();
						}
					}
					for( double zMgrid = mins.getZ(); zMgrid <= maxs.getZ(); zMgrid += dist ){
						for( double yMgrid = mins.getY(); yMgrid <= maxs.getY(); yMgrid += dist ){
							glBegin(GL_LINES);
								glColor3f(0.5,0.5,0.5);
								glVertex3f(mins.getX(), yMgrid, zMgrid);
								glVertex3f(maxs.getX(), yMgrid, zMgrid);
							glEnd();
						}
					}
				}
			}

			//Draw the Mesh Model
			if (((COME_Discretizer*)getGlobal())->cbMesh->isChecked()){
				
				COME_Mesh* mesh = (*iterOrgans)->getPointerToSurface();
				vector <COME_Face> faces = mesh->getFaces();
				vector<COME_Vertex3D>* allVertices = mesh->getVerticesGlobalPt();

				for (int i = 0; faces.size()> i; i++){
					
					glColor3f(faces[i].getColor()[0],faces[i].getColor()[1],faces[i].getColor()[2]);
					
					//Draw Mesh Triangles
					glBegin(GL_TRIANGLES);
						for ( int j=0;j<3;j++){
							int indexVertex = faces[i].getIndexVertex(j); 
							COME_Vector3D normal = allVertices->at(indexVertex).getNormalGlobalPosition();
							glNormal3f(normal.x,normal.y,normal.z);
							//printf( "NORMALS: %f %f %f \n", normal.x,normal.y,normal.z );
							COME_Vertex3D vertex = allVertices->at(indexVertex);
							glVertex3d(vertex.x,vertex.y,vertex.z);
						}
					glEnd();
					if(((COME_Discretizer*)getGlobal())->cbNormals->isChecked()){
						for ( int k=0;k<3;k++){
							int indexVertex = faces[i].getIndexVertex(k); 
							COME_Vector3D normal = allVertices->at(indexVertex).getNormalGlobalPosition();
							COME_Vertex3D vertex = allVertices->at(indexVertex);
							glBegin(GL_LINES);
							glColor3f(0.5,0.5,0.5);
							glVertex3f(vertex.x,vertex.y,vertex.z);
							glVertex3f(vertex.x+(8*normal.x),vertex.y+(8*normal.y), vertex.z+(8*normal.z));
							glEnd();
						}
					}
				}
			}
		}
		scene->unlock();
		
		if (((COME_Discretizer*)getGlobal())->cbMakeMovie->isChecked())
			//if( oldClock < ((COME_Discretizer*)getGlobal())->sim->getClock() ){
				saveSnapshot(true, true); // Warning, overwrite mode
			//	oldClock = ((COME_Discretizer*)getGlobal())->sim->getClock();
			//}
	}
	

}

void
COME_DiscretizerQGLWidget::postSelection(const QPoint& point){

	if( selectedName() == -1)
	{
		((COME_Discretizer*)getGlobal())->statusBar()->message( "No object selected.", 1000 );
	}
	else {
		
		list<COME_Molecule*>::iterator iter;
		int indNames = 0;
		for (iter = scene->getPatient(0)->getOrgan( 0 )->getTissue()->getShape()->begin(); iter != scene->getPatient(0)->getOrgan( 0 )->getTissue()->getShape()->end(); iter++, indNames++){
			
			if( selectedName() == indNames ){
				if( !(*iter)->isFixed() ){
					(*iter)->setFixed(true);
				} else if( (*iter)->getDescription() == "origin" ){
					(*iter)->setFixed(false);
					(*iter)->setDescription("free");
				} else {
					(*iter)->setDescription("origin");
				}
			}
		}
		
		char chMessage[30];
		sprintf( chMessage, "Molecule %d selected.", selectedName() );
		((COME_Discretizer*)getGlobal())->statusBar()->message( chMessage, 1000 );
	}

}

void
COME_DiscretizerQGLWidget::drawWithNames(){

	draw();
}
