/***************************************************************************
 *   Copyright (C) 2004 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/
#include "comediscretizer.h"
#include <qfiledialog.h>
#include <qspinbox.h>
#include <qcursor.h>
#include <qstatusbar.h>
#include <qlineedit.h>
//#include <comeqglwidget.h>
#include <come_discretizerqglwidget.h>
#include <general/come.h>
#include <general/comesimulator.h>
#include <general/comescenario.h>
#include <bio/comemoleculescartilage.h>


COME_Discretizer::COME_Discretizer()
 : discretizer(){
 
	scene = new COME_Scenario();
	sim = new COME_Simulator();
	sim->setScene( scene );
}

COME_Discretizer::COME_Discretizer( int argc, char ** argv)
 : discretizer(){
 
	scene = new COME_Scenario();
	sim = new COME_Simulator();
	sim->setScene( scene );

	if( ( argc > 1 ) && ( argc < 4 ) ){
		printf("Usage: discretizer [input_file] [output_file] [scale_factor]\n" );
	} else if( argc == 4 ){
		leScale->setText( argv[3] );
		default_output_file = argv[2];
		QString fileName = argv[1];
		if( !fileName.isEmpty() ){
			QString msg = "Loading ";
			statusBar()->message( msg + fileName );
			hourglass(true);
			int type = CARTILAGE;    
			scene->loadOrganMesh( fileName.latin1(), type, atof( leScale->text() ) );
			openglArea->setScene( scene );
			openglArea->setGlobal( (COME*)this );
			statusBar()->message( "Loaded.", 2000 );
			hourglass(false);
			
			// Set scene radius for view
			double sceneRadius = 0.01;
			COME_Point3D mins, maxs;
			list<COME_BioStructure*>::const_iterator iterOrgans;
			for( iterOrgans = ((list<COME_BioStructure *>*)scene->getPatient(0)->getPtOrganList())->begin(); iterOrgans != ((list<COME_BioStructure *>*)scene->getPatient(0)->getPtOrganList())->end(); iterOrgans++  ){
				
				((COME_MoleculesCartilage*)(*iterOrgans))->getSurface()->getEnvelop( mins, maxs );
				//sceneRadius = mins.vpDistance( maxs ) > sceneRadius ? mins.vpDistance( maxs ) : sceneRadius;
				sceneRadius = mins.vpDistance( COME_Point3D() ) > sceneRadius ? mins.vpDistance( COME_Point3D() ) : sceneRadius;
				sceneRadius = maxs.vpDistance( COME_Point3D() ) > sceneRadius ? maxs.vpDistance( COME_Point3D() ) : sceneRadius;
			}
			openglArea->setSceneRadius( sceneRadius + sceneRadius*0.1 );
			openglArea->camera()->showEntireScene();
		}
	}
}


COME_Discretizer::~COME_Discretizer(){

	delete scene;
	delete sim;
}

void
COME_Discretizer::fileOpen(){

	QString fileName = QFileDialog::getOpenFileName(
                    ".",
                    "Mesh files (*.iv *.vtk *.wrl)",
                    this,
                    "open file dialog"
                    "Choose a file" );
	if( !fileName.isEmpty() ){
		QString msg = "Loading ";
		statusBar()->message( msg + fileName );
		hourglass(true);
		int type = CARTILAGE;    
		scene->loadOrganMesh( fileName.latin1(), type, atof( leScale->text() ) );
		openglArea->setScene( scene );
		openglArea->setGlobal( (COME*)this );
		statusBar()->message( "Loaded.", 2000 );
		hourglass(false);
		
		// Set scene radius for view
		double sceneRadius = 0.01;
		COME_Point3D mins, maxs;
		list<COME_BioStructure*>::const_iterator iterOrgans;
		for( iterOrgans = ((list<COME_BioStructure *>*)scene->getPatient(0)->getPtOrganList())->begin(); iterOrgans != ((list<COME_BioStructure *>*)scene->getPatient(0)->getPtOrganList())->end(); iterOrgans++  ){
			
			((COME_MoleculesCartilage*)(*iterOrgans))->getSurface()->getEnvelop( mins, maxs );
			//sceneRadius = mins.vpDistance( maxs ) > sceneRadius ? mins.vpDistance( maxs ) : sceneRadius;
			sceneRadius = mins.vpDistance( COME_Point3D() ) > sceneRadius ? mins.vpDistance( COME_Point3D() ) : sceneRadius;
			sceneRadius = maxs.vpDistance( COME_Point3D() ) > sceneRadius ? maxs.vpDistance( COME_Point3D() ) : sceneRadius;
		}
		openglArea->setSceneRadius( sceneRadius + sceneRadius*0.1 );
		openglArea->camera()->showEntireScene();
	}
}

void
COME_Discretizer::fileExportAs(){

	QString fileName;
	QFileDialog* fd = new QFileDialog( this, "save as dialog", TRUE );
	fd->setCaption( "Export molecules file as...");
	fd->setMode( QFileDialog::AnyFile );
	fd->setFilter( "Molecules (*.xml)" );
	if( default_output_file != "" )
		fd->setSelection( default_output_file.c_str() );
	
	if ( fd->exec() == QDialog::Accepted ){
		hourglass(true);
		fileName = fd->selectedFile();
		printf( "Saving %s... ", fileName.latin1() );
		scene->saveFile( fileName.latin1(), sim );
		printf( " saved.\n" );
		hourglass(false);
	}
    
}

void
COME_Discretizer::updateSampling(){

	if( scene ){
		statusBar()->message( "Updating...");
		hourglass(true);
		scene->lock();

		//Main loop: For each organ re-sample
		list<COME_BioStructure*>::const_iterator iterOrgans;
		for( iterOrgans = ((list<COME_BioStructure *>*)scene->getPatient(0)->getPtOrganList())->begin(); iterOrgans != ((list<COME_BioStructure *>*)scene->getPatient(0)->getPtOrganList())->end(); iterOrgans++  ){
			
			((COME_MoleculesCartilage*)(*iterOrgans))->discretize( BEST, ((double)sbDistance->value())/1000.0, ((double)sbRadius->value())/1000.0 );

		}
		scene->unlock();
		// Simulate physics here to balance distances between molecules
		sim->setFPS(600);
		sim->setDuration(1);
		//sim->start();
		
		scene->lock();
		list<COME_Molecule*>::iterator iter;
		for (iter = scene->getPatient(0)->getOrgan( 0 )->getTissue()->getShape()->begin(); iter != scene->getPatient(0)->getOrgan( 0 )->getTissue()->getShape()->end(); iter++){
			(*iter)->setFixed(false);
			(*iter)->setDescription("free");
		}
		scene->unlock();
		
		statusBar()->message( "Updated.", 2000 );
		hourglass(false);
	}

}

void
COME_Discretizer::hourglass( bool yesno ){

	if( yesno ){
		setCursor( Qt::WaitCursor );
		openglArea->setCursor( Qt::WaitCursor );
	} else {
		setCursor( Qt::ArrowCursor );
		openglArea->setCursor( Qt::ArrowCursor );
	}
}
