
/***************************************************************************
 *   Copyright (C) 2005 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include	<general/comesimulator.h>
#include	<general/comescenario.h>
#include	<general/comexml.h>
#include	<string>

using namespace std;

COME_Scenario *scene;
COME_Simulator *simulator;

int loadData( string file_name );
int exportData( string file_name );

int
main( int argc, char ** argv ) {

	if( ( argc > 1 ) && ( argc < 3 ) ){
		printf("Usage: jointBuilder [input_file] [output_file]\n" );
	} else if( argc == 3 ){
		string output_file = argv[2];
		string input_file = argv[1];

		if( !loadData( input_file ) ){
			printf( "Input file %s could not be properly loaded. %s has NOT been created.\n", input_file.c_str(), output_file.c_str());
			return 0;
		}
		if( !exportData( output_file ) ){
			printf( "Error exporting %s. The file has NOT been created.\n", output_file.c_str());
			return 0;
		}
	}
	
	return 1;
}

int
loadData( string file_name ){

	scene = new COME_Scenario();
	simulator = new COME_Simulator();
	simulator->setScene( scene );

	COME_Xml doc;
	return ( doc.loadIntegrationFile( file_name, *(scene->getPatientList()), simulator, scene ) );
}

int
exportData( string file_name ){

	COME_Xml doc;
	return doc.exportIntegrationFile( file_name, *(scene->getPatientList()), simulator );
}