/****************************************************************************

 This file is part of the QGLViewer library.
 Copyright (C) 2002, 2003, 2004, 2005 Gilles Debunne (Gilles.Debunne@imag.fr)
 Version 2.1.1-6, packaged on October 7, 2005.

 http://artis.imag.fr/Members/Gilles.Debunne/QGLViewer

 libQGLViewer is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 libQGLViewer is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with libQGLViewer; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*****************************************************************************/

// TP OpenGL: Joerg Liebelt, Serigne Sow
#include "tree.h"

using namespace qglviewer;

bool TREE::LoadTexture(char* filename )
{
  QImage image;
  if (image.load(filename))
    {
      texture= QGLWidget::convertToGLFormat(image);

      //construire les textures openGL
      glGenTextures( 1, &(texID) );
      glBindTexture( GL_TEXTURE_2D, (texID) );

      glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR );
      glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_LINEAR);

      gluBuild2DMipmaps( GL_TEXTURE_2D, GL_RGBA, texture.width(), texture.height(),
			 GL_RGBA, GL_UNSIGNED_BYTE, texture.bits() );
    }
  else
    {
      printf(" treetexture failed\n");
      return false;
    }
  return true;
}


void TREE::initTrees(QUADTREE ter, int num, float waterLevel)
{
  int i;
  myTerrain = ter;
  numTrees = num;
  treeInfo = new Vec[numTrees];
  srand( time(NULL) );
  for (i=0;i<numTrees;i++)
    {
      do {
	treeInfo[i].setValue(rand( )%myTerrain.sizeHeightMap,
			     rand( )%myTerrain.sizeHeightMap,
			     rand()%myTerrain.sizeHeightMap*treeSizeFactor/myTerrain.sizeHeightMap);
      } while (myTerrain.GetScaledHeightAtPoint((int)treeInfo[i].x,(int)treeInfo[i].y) <= waterLevel);
    }
}

void TREE::Render()
{
  float dim;
  int i;
  glDisable(GL_LIGHTING);

  glAlphaFunc(GL_GREATER, 0.5);	//on enleve automatiquement les pixels de la texture marques "transparent"
  glEnable(GL_ALPHA_TEST);

  glEnable( GL_TEXTURE_2D );

  for (i=0;i<numTrees;i++)
    {
      //on place l'arbre a une hauteur reduit de 5%, car les surface n'ont souvent pas l'hauteur exact et
      // .. les arbres ont tendance a "voler" dans l'air...
      glPushMatrix( );

      glTranslatef( treeInfo[i].x/myTerrain.sizeHeightMap,
		    myTerrain.GetScaledHeightAtPoint((int)treeInfo[i].x,
						     (int)treeInfo[i].y)/myTerrain.sizeHeightMap*0.99,
		    treeInfo[i].y/myTerrain.sizeHeightMap);
      dim = treeInfo[i].z;
      glBindTexture( GL_TEXTURE_2D, texID);
      glBegin( GL_TRIANGLE_FAN );
      glTexCoord2f( 1.0f, 1.0f ); glVertex3f( dim, dim,0 );
      glTexCoord2f( 1.0f, 0.0f ); glVertex3f( dim, 0,0 );
      glTexCoord2f( 0.0f, 0.0f ); glVertex3f( 0, 0,0 );
      glTexCoord2f( 0.0f, 1.0f ); glVertex3f( 0, dim,0 );
      glEnd( );
      glBindTexture( GL_TEXTURE_2D, texID);
      glBegin( GL_TRIANGLE_FAN );
      glTexCoord2f( 1.0f, 1.0f ); glVertex3f( dim/2, dim,-dim/2 );
      glTexCoord2f( 1.0f, 0.0f ); glVertex3f( dim/2, 0,-dim/2 );
      glTexCoord2f( 0.0f, 0.0f ); glVertex3f( dim/2, 0,dim/2 );
      glTexCoord2f( 0.0f, 1.0f ); glVertex3f( dim/2, dim,dim/2 );
      glEnd( );

      glPopMatrix( );
    }


  glDisable(GL_ALPHA_TEST);
}
