/***************************************************************************
 *   Copyright (C) 2004 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <come_mechatestqglwidget.h>
#include <comemechatester.h>
#include <general/comescenario.h>
#include <general/comesimulator.h>
#include <qcheckbox.h>
#include <qtimer.h>
#include <qcursor.h>
#include <qslider.h>
#include <qpopupmenu.h>
#include <qspinbox.h>
#include <qstatusbar.h>
#include <qlistbox.h>
#include <qlcdnumber.h>
#include <GL/glut.h>

double oldClock;


COME_MechatestQGLWidget::COME_MechatestQGLWidget( QWidget *parent, const char *name )
 : COME_QGLWidget( parent, name )
{
	oldClock = 0.0;
}


COME_MechatestQGLWidget::~COME_MechatestQGLWidget()
{
}

void
COME_MechatestQGLWidget::draw(){

	//CGparameter 
	//cgGLSetParameter3fv(cgGetNamedParameter(fragmentProgram, "lightColor"), lightColor);
	
	
	if( scene ){

		// Display simulation data
		if( ((COME_Mechatester*)getGlobal())->sim->isRunning() ){
			
			char chrClock[10];
			sprintf( chrClock, "%2.4f", ((COME_Mechatester*)getGlobal())->sim->getClock() );
			((COME_Mechatester*)getGlobal())->lcdForceClock->display(chrClock);
			((COME_Mechatester*)getGlobal())->lcdDispClock->display(chrClock);
			((COME_Mechatester*)getGlobal())->updateEquation();
		}

		scene->lock();

		// Update clamp attach
		//((COME_Mechatester*)getGlobal())->updateClampIntersections();

		//Main loop: For each organ display the object
		list<COME_BioStructure*>::const_iterator iterOrgans;
		int organName = 0;
		for( iterOrgans = ((list<COME_BioStructure *>*)scene->getPatient(0)->getPtOrganList())->begin(); iterOrgans != ((list<COME_BioStructure *>*)scene->getPatient(0)->getPtOrganList())->end(); iterOrgans++  ){
			list<COME_Molecule*>::const_iterator iterCells;
			glPushName(organName++);
		
			//Draw the Sphere Model			
			if (((COME_Mechatester*)getGlobal())->cbSpheres->isChecked()){
				for ( iterCells = (*iterOrgans)->getTissue()->getShape()->begin(); iterCells != (*iterOrgans)->getTissue()->getShape()->end(); iterCells++ ){
					
					COME_Point3D position = (*iterCells)->getGlobalPosition();
					glPushMatrix();
						glTranslatef(position.getX(),position.getY(),position.getZ());
				
						if( (*iterCells)->intersectClamp() ){
							glColor3f( 1.0 - (*iterCells)->getMaterial()->getColor().getPointAsArray()[0], 1.0 - (*iterCells)->getMaterial()->getColor().getPointAsArray()[1], 1.0 - (*iterCells)->getMaterial()->getColor().getPointAsArray()[2]);
						} else {
							glColor3f((*iterCells)->getMaterial()->getColor().getPointAsArray()[0],(*iterCells)->getMaterial()->getColor().getPointAsArray()[1],(*iterCells)->getMaterial()->getColor().getPointAsArray()[2]);
						}
						glutSolidSphere((*iterCells)->getRadius()*((double)((COME_Mechatester*)getGlobal())->sliderScale->value()/100.0), 15, 15);
					glPopMatrix();
					
					if( ((COME_Mechatester*)getGlobal())->cbLinks->isChecked() ){
						list<COME_MoleculeLink*>::iterator iterThis;
						glDisable(GL_LIGHTING);
						for(iterThis = (*iterCells)->getConnectionList()->begin(); !( iterThis == (*iterCells)->getConnectionList()->end() ); iterThis++){
							COME_Point3D position2 = (*iterThis)->getOtherElement((*iterCells))->getGlobalPosition();
							glBegin(GL_LINES);
								glColor3f(0.9,0.9,0.9);
								glVertex3f(position.getX(),position.getY(),position.getZ());
								glVertex3f(position2.getX(),position2.getY(),position2.getZ());
							glEnd();
						}
						glEnable(GL_LIGHTING);
					}
				}
			}


			//Draw the Mesh Model
			COME::flagSkinning = false;
			if(((COME_Mechatester*)getGlobal())->cbMesh->isChecked() || ( (*iterOrgans)->getDescription() == "clamp0" ) || ( (*iterOrgans)->getDescription() == "clamp1" ) ){
				COME::flagSkinning = true;
				COME_Mesh* mesh = (*iterOrgans)->getPointerToSurface();
				if( mesh ){
					vector <COME_Face> faces = mesh->getFaces();
					vector<COME_Vertex3D>* allVertices = mesh->getVerticesGlobalPt();
	
					for (int i = 0; faces.size()> i; i++){
						
						glColor3f(faces[i].getColor()[0],faces[i].getColor()[1],faces[i].getColor()[2]);
						
						//Draw Mesh Triangles
						glBegin(GL_TRIANGLES);
							for ( int j=0;j<3;j++){
								int indexVertex = faces[i].getIndexVertex(j); 
								COME_Vector3D normal = allVertices->at(indexVertex).getNormalGlobalPosition();
								glNormal3f(normal.x,normal.y,normal.z);
								//printf( "NORMALS: %f %f %f \n", normal.x,normal.y,normal.z );
								COME_Vertex3D vertex = allVertices->at(indexVertex);
								glVertex3d(vertex.x,vertex.y,vertex.z);
							}
						glEnd();
						if(((COME_Mechatester*)getGlobal())->cbNormals->isChecked()){
							for ( int k=0;k<3;k++){
								int indexVertex = faces[i].getIndexVertex(k); 
								COME_Vector3D normal = allVertices->at(indexVertex).getNormalGlobalPosition();
								COME_Vertex3D vertex = allVertices->at(indexVertex);
								glBegin(GL_LINES);
								glColor3f(0.5,0.5,0.5);
								glVertex3f(vertex.x,vertex.y,vertex.z);
								glVertex3f(vertex.x+(sceneRadius()/20.0*normal.x),vertex.y+(sceneRadius()/20.0*normal.y), vertex.z+(sceneRadius()/20.0*normal.z));
								glEnd();
							}
						}
					}
				}
				//}
			}
			COME::flagSkinning = true;
			glPopName();
		}
		scene->unlock();
		
		if (((COME_Mechatester*)getGlobal())->cbMakeMovie->isChecked())
			if( oldClock < ((COME_Mechatester*)getGlobal())->sim->getClock() ){
				saveSnapshot(true, true); // Warning, overwrite mode
				oldClock = ((COME_Mechatester*)getGlobal())->sim->getClock();
				oldClock = 0.0;
			}
	}

}

void
COME_MechatestQGLWidget::keyPressEvent(QKeyEvent *e){

  // Get event state key
  const Qt::ButtonState state = (Qt::ButtonState)(e->state() & Qt::KeyButtonMask);
  // Bug in Qt : use 0x0f00 instead of Qt::KeyButtonMask with Qt versions < 3.1

  oldClock = 0.0;
  
  // A simple switch on e->key() is not sufficient if we want to take state key into account.
  // With a switch, it would have been impossible to separate 'F' from 'CTRL+F'.
  // That's why we use imbricated if...else and a "handled" boolean.
  bool handled = false;
  switch( e->key() ){

  	case Qt::Key_Right:
		if(state==Qt::ShiftButton){
			((COME_Mechatester*)getGlobal())->rotateSelected( 1, 0, 0 );
			handled = true;
		} else
		if(state==Qt::ControlButton){
			((COME_Mechatester*)getGlobal())->translateSelected( 1, 0, 0 );
			handled = true;
		} else
		if(state==Qt::AltButton){
			((COME_Mechatester*)getGlobal())->scaleSelected( 1, 0, 0 );
			handled = true;
		}
		break;
	case Qt::Key_Left:
		if(state==Qt::ShiftButton){
			((COME_Mechatester*)getGlobal())->rotateSelected( -1, 0, 0 );
			handled = true;
		} else
		if(state==Qt::ControlButton){
			((COME_Mechatester*)getGlobal())->translateSelected( -1, 0, 0 );
			handled = true;
		} else
		if(state==Qt::AltButton){
			((COME_Mechatester*)getGlobal())->scaleSelected( -1, 0, 0 );
			handled = true;
		}
		break;
	case Qt::Key_Up:
		if(state==Qt::ShiftButton){
			((COME_Mechatester*)getGlobal())->rotateSelected( 0, 1, 0 );
			handled = true;
		} else
		if(state==Qt::ControlButton){
			((COME_Mechatester*)getGlobal())->translateSelected( 0, 1, 0 );
			handled = true;
		} else
		if(state==Qt::AltButton){
			((COME_Mechatester*)getGlobal())->scaleSelected( 0, 1, 0 );
			handled = true;
		}
		break;
	case Qt::Key_Down:
		if(state==Qt::ShiftButton){
			((COME_Mechatester*)getGlobal())->rotateSelected( 0, -1, 0 );
			handled = true;
		} else
		if(state==Qt::ControlButton){
			((COME_Mechatester*)getGlobal())->translateSelected( 0, -1, 0 );
			handled = true;
		} else
		if(state==Qt::AltButton){
			((COME_Mechatester*)getGlobal())->scaleSelected( 0, -1, 0 );
			handled = true;
		}
		break;
	case Qt::Key_PageUp:
		if(state==Qt::ShiftButton){
			((COME_Mechatester*)getGlobal())->rotateSelected( 0, 0, 1 );
			handled = true;
		} else
		if(state==Qt::ControlButton){
			((COME_Mechatester*)getGlobal())->translateSelected( 0, 0, 1 );
			handled = true;
		} else
		if(state==Qt::AltButton){
			((COME_Mechatester*)getGlobal())->scaleSelected( 0, 0, 1 );
			handled = true;
		}
		break;
	case Qt::Key_PageDown:
		if(state==Qt::ShiftButton){
			((COME_Mechatester*)getGlobal())->rotateSelected( 0, 0, -1 );
			handled = true;
		} else
		if(state==Qt::ControlButton){
			((COME_Mechatester*)getGlobal())->translateSelected( 0, 0, -1 );
			handled = true;
		} else
		if(state==Qt::AltButton){
			((COME_Mechatester*)getGlobal())->scaleSelected( 0, 0, -1 );
			handled = true;
		}
		break;
  }

	if (!handled){
		COME_QGLWidget::keyPressEvent(e);
	} else {
		updateGL();
	}
}

void
COME_MechatestQGLWidget::postSelection(const QPoint& point){

	if( selectedName() == -1)
	{
		// Unselect all if no object is selected.
		scene->getPatient(0)->unselectAll();
		((COME_Mechatester*)getGlobal())->statusBar()->message( "No object selected.", 1000 );
	}
	else {
		scene->getPatient(0)->unselectAll();
		scene->getPatient(0)->getOrgan( selectedName() )->select(true);
		if( scene->getPatient(0)->getSelected()->getTissue()->getShape()->begin() != scene->getPatient(0)->getSelected()->getTissue()->getShape()->end() ){
			((COME_Mechatester*)getGlobal())->listMaterials->setSelected( ((COME_Mechatester*)getGlobal())->listMaterials->findItem ( scene->getPatient(0)->getSelected()->getTissue()->getShape()->front()->getMaterial()->getDescription().c_str() ), true );
			((COME_Mechatester*)getGlobal())->loadMaterialProperties();
		}
		char chMessage[30];
		sprintf( chMessage, "Object %d selected.", selectedName() );
		((COME_Mechatester*)getGlobal())->statusBar()->message( chMessage, 1000 );
	}

}

void
COME_MechatestQGLWidget::drawWithNames(){

	draw();
}
