/***************************************************************************
 *   Copyright (C) 2004 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef COMEMECHATESTER_H
#define COMEMECHATESTER_H

#include <mechatester.h>
#include <string>
using namespace std;

class COME_Simulator;
class COME_Scenario;
class COME_Material;
class COME_Molecule;

/**
@author Anderson Maciel
*/
class COME_Mechatester : public mechatester
{
private:
	double initialLength, previousLenght, pressureArea;
	COME_Molecule* molecFixSelected;
	COME_Molecule* molecMobileSelected;
	void hourglass( bool yesno );
	string default_output_file;

protected:
	

public:
	COME_Mechatester();
	
	~COME_Mechatester();
	
	public slots:
	virtual void fileOpen();
	virtual void fileExportAs();
	virtual void selectMaterial();
	virtual void materialChanged( int l, int c );
	virtual void clickedNewMaterial();
	virtual void clickedDelMaterial();
	virtual void clickedAssociate();
	virtual void clickedStartSim();
	virtual void clickedCheck();
	virtual void clickedReset();
	virtual void changedNumIntegration();
	
	void	loadFileIfArguments( int argc, char ** argv );

	void	rotateSelected( int rx, int ry, int rz );
	void	translateSelected( int dx, int dy, int dz );
	void	scaleSelected( int fx, int fy, int fz );
	
	void	updateMaterialsList();
	void	loadMaterialProperties();
	void	updateClampIntersections();
	void	updateEquation();
    
	COME_Simulator	*sim;
	COME_Scenario	*scene;
	COME_Material	*selectedMaterial;

};

#endif
