/***************************************************************************
 *   Copyright (C) 2004 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <come_modeljointqglwidget.h>
#include <comemodeljoint.h>
#include <general/comescenario.h>
#include <general/comesimulator.h>
#include <kinematics/comepolyaxialjoint.h>
#include <physics/comecollide.h>
#include <kinematics/comedof.h>
//#include <physics/comeproximity.h>
#include <qcheckbox.h>
#include <qtimer.h>
#include <qcursor.h>
#include <qslider.h>
#include <qpopupmenu.h>
#include <qspinbox.h>
#include <qstatusbar.h>
#include <qlistbox.h>
#include <qradiobutton.h>
#include <qlcdnumber.h>
#include <qpushbutton.h>
#include <qfont.h>
#include <GL/glut.h>

double oldClock;

COME_ModelJointQGLWidget::COME_ModelJointQGLWidget( QWidget *parent, const char *name )
 : COME_QGLWidget( parent, name )
{
	oldClock = 0.0;
}


COME_ModelJointQGLWidget::~COME_ModelJointQGLWidget()
{
}

void
COME_ModelJointQGLWidget::draw(){

	//CGparameter 
	//cgGLSetParameter3fv(cgGetNamedParameter(fragmentProgram, "lightColor"), lightColor);
	
	if( scene ){

		// Display simulation data
		if( (((COME_ModelJoint*)getGlobal())->sim ) && ( ((COME_ModelJoint*)getGlobal())->sim->isRunning() ) ){
			
			char chrClock[10];
			sprintf( chrClock, "%2.4f", ((COME_ModelJoint*)getGlobal())->sim->getClock() );
			((COME_ModelJoint*)getGlobal())->lcdForceClock->display(chrClock);
		} else {
			if( ((COME_ModelJoint*)getGlobal())->sim->getStop() ){
				((COME_ModelJoint*)getGlobal())->bpStartForce->setDown( false );
				((COME_ModelJoint*)getGlobal())->sim->setStop(false);
			}
		}

		scene->lock();
		
		
		/// TEST:  DISPLAY SELECTED PROXIMITY
		glDisable(GL_LIGHTING);
		if (((COME_ModelJoint*)getGlobal())->cbProximities->isChecked()){
			vector<COME_Proximity>* drawPS = scene->getCollisionDetector()->getProximityStructurePt();
			for( int iPS = 0; iPS < drawPS->size(); iPS++ ){
		
				COME_Point3D bPosition = ((*drawPS)[iPS].pointOnB);
				COME_Point3D aPosition = (*((*drawPS)[iPS].objA));
				
				glBegin(GL_LINES);
					glColor3f(1.0,1.0,1.0);
					glVertex3f(aPosition.x,aPosition.y,aPosition.z);
					glVertex3f(bPosition.x, bPosition.y, bPosition.z);
				glEnd();

				glPushMatrix();
					glTranslatef(bPosition.getX(),bPosition.getY(),bPosition.getZ());
					glColor3f(0,1,1);
					glutSolidSphere(0.02*((double)((COME_ModelJoint*)getGlobal())->sliderScale->value()/100.0), 15, 15);
				glPopMatrix();
				
				/*for( int iNF = 0; iNF < (*drawPS)[iPS].faceB->getNeighbourFaces().size(); iNF++ ){
				
					COME_Point3D pSphere = ((COME_Mesh*)((*drawPS)[iPS].faceB->getParent()))->getAFacePt( (*drawPS)[iPS].faceB->getNeighbourFaces()[iNF] )->getClosestPointOnFaceToPoint( aPosition );
					glPushMatrix();
						glTranslatef(pSphere.getX(),pSphere.getY(),pSphere.getZ());
						glColor3f(0,0,0);
						glutSolidSphere(0.02*((double)((COME_ModelJoint*)getGlobal())->sliderScale->value()/100.0), 15, 15);
					glPopMatrix();
					
				}*/
			}
		}
		glEnable(GL_LIGHTING);
		
		/////////////////////////////////////////////////////////////
		
		int offset = 20;
		char chrType[100];
		strcpy( chrType, "0.0");
		QString lineStress = "";
		int organName = 0;
		for( int iP = 0; iP < scene->getPatientList()->size(); iP++ ){
			
			glDisable(GL_LIGHTING);
				glColor3f( 1, 1, 1 );
				drawText(10,400, "Top stresses (failure stress) [kPa]:" );
				
				COME_Joint *hipjoint = scene->getPatient(iP)->getJointByName("hip");
				if( hipjoint ){
					COME_Point3D jointStatus = ((COME_PolyaxialJoint *)hipjoint)->getCurrentAngles();
					drawText(width()-100,460, "Hip angles:" );
					sprintf( chrType, "Ext/Flex: %4.2f", jointStatus.x );
					drawText(width()-100,460+offset*1, chrType );
					sprintf( chrType, "Add/Abd: %4.2f", jointStatus.y );
					drawText(width()-100,460+offset*2, chrType );
					sprintf( chrType, "Int/Ext rot: %4.2f", jointStatus.z );
					drawText(width()-100,460+offset*3, chrType );
				}
			glEnable(GL_LIGHTING);
			
			//Main loop: For each organ display the object
			list<COME_BioStructure*>::const_iterator iterOrgans;
			
			for( iterOrgans = ((list<COME_BioStructure *>*)scene->getPatient(iP)->getPtOrganList())->begin(); iterOrgans != ((list<COME_BioStructure *>*)scene->getPatient(iP)->getPtOrganList())->end(); iterOrgans++  ){
				glDisable(GL_LIGHTING);
					glColor3f( 1, 1, 1 );
					if( (*iterOrgans)->getTissue()->getShape()->size() > 0 )
						sprintf( chrType, "%10.1f (%10.1f )", (*iterOrgans)->getTopStress()/1000.0, (*iterOrgans)->getTissue()->getMoleculesMaterial()->getMaxStress()/1000.0 );
					else
						sprintf( chrType, "Not computed for bone." );
					lineStress = QString( (*iterOrgans)->getDescription().c_str() ) + QString( ": " ) + QString( chrType );
					drawText(10,420 + offset*organName, lineStress );
					
					// ROM stuff
					if( (*iterOrgans)->getTissue()->getShape()->size() > 0 ){
						if ( hipjoint ) { 
							COME_Point3D currentStatus = ((COME_PolyaxialJoint *)hipjoint)->getCurrentAngles();
							if( !( ( (*iterOrgans)->getTopStress() >= (*iterOrgans)->getTissue()->getMoleculesMaterial()->getMaxStress() ) && (((COME_ModelJoint*)getGlobal())->cbStressLimit->isChecked()) )){
							
								double fMin, fMax, aMin, aMax, tMin, tMax;
								if( currentStatus.x < ( hipjoint->getDofList()[0]->getComfortMin() * 180.0 / M_PI ) )
									hipjoint->getDofList()[0]->setComfortMin( currentStatus.x * M_PI / 180.0 );
								if( currentStatus.x > ( hipjoint->getDofList()[0]->getComfortMax() * 180.0 / M_PI ) )
									hipjoint->getDofList()[0]->setComfortMax( currentStatus.x * M_PI / 180.0 );
								
								if( currentStatus.y < ( hipjoint->getDofList()[1]->getComfortMin() * 180.0 / M_PI ) )
									hipjoint->getDofList()[1]->setComfortMin( currentStatus.y * M_PI / 180.0 );
								if( currentStatus.y > ( hipjoint->getDofList()[1]->getComfortMax() * 180.0 / M_PI ) )
									hipjoint->getDofList()[1]->setComfortMax( currentStatus.y * M_PI / 180.0 );
								
								if( currentStatus.z < ( hipjoint->getDofList()[2]->getComfortMin() * 180.0 / M_PI ) )
									hipjoint->getDofList()[2]->setComfortMin( currentStatus.z * M_PI / 180.0 );
								if( currentStatus.z > ( hipjoint->getDofList()[2]->getComfortMax() * 180.0 / M_PI ) )
									hipjoint->getDofList()[2]->setComfortMax( currentStatus.z * M_PI / 180.0 );
							
							} else if ( (*iterOrgans)->getTissue()->getMoleculesMaterial()->getMaxStress() > 0.0 ) {
								printf( "Limit found!! ROM by stress: F/E[%4.2f %4.2f] A/A[%4.2f %4.2f] T[%4.2f %4.2f] \n",
								hipjoint->getDofList()[0]->getComfortMin() * 180.0 / M_PI,
								hipjoint->getDofList()[0]->getComfortMax() * 180.0 / M_PI,
								hipjoint->getDofList()[1]->getComfortMin() * 180.0 / M_PI,
								hipjoint->getDofList()[1]->getComfortMax() * 180.0 / M_PI,
								hipjoint->getDofList()[2]->getComfortMin() * 180.0 / M_PI,
								hipjoint->getDofList()[2]->getComfortMax() * 180.0 / M_PI );
							}
							
							sprintf( chrType, "ROM by stress: F/E[%4.2f %4.2f] A/A[%4.2f %4.2f] T[%4.2f %4.2f]",
								hipjoint->getDofList()[0]->getComfortMin() * 180.0 / M_PI,
								hipjoint->getDofList()[0]->getComfortMax() * 180.0 / M_PI,
								hipjoint->getDofList()[1]->getComfortMin() * 180.0 / M_PI,
								hipjoint->getDofList()[1]->getComfortMax() * 180.0 / M_PI,
								hipjoint->getDofList()[2]->getComfortMin() * 180.0 / M_PI,
								hipjoint->getDofList()[2]->getComfortMax() * 180.0 / M_PI
							);
							lineStress = (*iterOrgans)->getDescription().c_str() + QString( chrType );
							drawText(150, 20 + offset*organName, lineStress );
						}
					}
				
				glEnable(GL_LIGHTING);
				
				list<COME_Molecule*>::const_iterator iterCells;
				glPushName(organName++);

				// testing collision volume sphere
				if (((COME_ModelJoint*)getGlobal())->cbCollisionVolume->isChecked()){
					glutSolidSphere((*iterOrgans)->getCollisionRadius(), 15, 15);
				}

				//Draw the Sphere Model			
				if (((COME_ModelJoint*)getGlobal())->cbSpheres->isChecked()){
					for ( iterCells = (*iterOrgans)->getTissue()->getShape()->begin(); iterCells != (*iterOrgans)->getTissue()->getShape()->end(); iterCells++ ){
						
						//if( !( (*iterOrgans)->getDescription() == "pubofemoral" ) ) continue ; // used for RNW04 demo to highlight ligament
					
						COME_Point3D position = (*iterCells)->getGlobalPosition();
						glPushMatrix();
							glTranslatef(position.getX(),position.getY(),position.getZ());

							if( (*iterCells)->intersectClamp() || (*iterCells)->isFixed() ){
								glColor3f( 1.0 - (*iterCells)->getMaterial()->getColor().getPointAsArray()[0], 1.0 - (*iterCells)->getMaterial()->getColor().getPointAsArray()[1], 1.0 - (*iterCells)->getMaterial()->getColor().getPointAsArray()[2]);
								if( (*iterCells)->intersectClamp() || (*iterCells)->getDescription() == "origin" ){
									glColor3f( 1.0 - (*iterCells)->getMaterial()->getColor().getPointAsArray()[0], (*iterCells)->getMaterial()->getColor().getPointAsArray()[1], 1.0 - (*iterCells)->getMaterial()->getColor().getPointAsArray()[2]);
								}
							} else {
								glColor3f((*iterCells)->getMaterial()->getColor().getPointAsArray()[0],(*iterCells)->getMaterial()->getColor().getPointAsArray()[1],(*iterCells)->getMaterial()->getColor().getPointAsArray()[2]);
							}
							glutSolidSphere((*iterCells)->getRadius()*((double)((COME_ModelJoint*)getGlobal())->sliderScale->value()/100.0), 15, 15);
						glPopMatrix();
						
						// TEMP draw displacements
						/*COME_Point3D dispPosition = (*iterCells)->getINITPositionGlobal();
						glBegin(GL_LINES);
							glColor3f(1.0,1.0,1.0);
							glVertex3f(position.x,position.y,position.z);
							glVertex3f(dispPosition.x, dispPosition.y, dispPosition.z);
						glEnd();*/
						
						if( ((COME_ModelJoint*)getGlobal())->cbLinks->isChecked() ){
							glDisable(GL_LIGHTING);
							list<COME_MoleculeLink*>::iterator iterThis;
							for(iterThis = (*iterCells)->getConnectionList()->begin(); !( iterThis == (*iterCells)->getConnectionList()->end() ); iterThis++){
								COME_Point3D position2 = (*iterThis)->getOtherElement((*iterCells))->getGlobalPosition();
								glBegin(GL_LINES);
									glColor3f(0.9,0.9,0.9);
									glVertex3f(position.getX(),position.getY(),position.getZ());
									glVertex3f(position2.getX(),position2.getY(),position2.getZ());
								glEnd();
							}
							glEnable(GL_LIGHTING);
						}
					}
				}
	
	
				//Draw the Mesh Model
				if (((COME_ModelJoint*)getGlobal())->cbMesh->isChecked()){
				
					if (((COME_ModelJoint*)getGlobal())->cbTexture->isChecked()){
						glEnable(GL_TEXTURE_2D);
					}
					
					COME_Mesh* mesh = (*iterOrgans)->getPointerToSurface();
					if( mesh ){
						glBindTexture(GL_TEXTURE_2D, *(mesh->getTextureID()) ); 
						vector <COME_Face> faces = mesh->getFaces();
						vector<COME_Vertex3D>* allVertices = mesh->getVerticesGlobalPt();
		
						for (int i = 0; faces.size()> i; i++){
							
							//glColor3f(faces[i].getColor()[0],faces[i].getColor()[1],faces[i].getColor()[2]);

							//Draw Mesh Triangles
							glBegin(GL_TRIANGLES);
								for ( int j=0;j<3;j++){
									int indexVertex = faces[i].getIndexVertex(j); 
									COME_Vector3D normal = allVertices->at(indexVertex).getNormalGlobalPosition();
									glNormal3f(normal.x,normal.y,normal.z);
									//printf( "NORMALS: %f %f %f \n", normal.x,normal.y,normal.z );
									COME_Vertex3D vertex = allVertices->at(indexVertex);
									
									// COLOR STRESS
									if (((COME_ModelJoint*)getGlobal())->rbStress->isChecked()){
										double R, B, maxS = 3000;
										double S = vertex.getStress();
										if( S < maxS / 2.0 ){
											B = ( 2.0 / maxS ) * S;
											R = 0.0;
										} else {
											R = ( 2.0 / maxS ) * ( S - maxS / 2.0);
											B = 1.0;
										}
						
										R += 0.3;
										B += 0.3;
										
										glColor3f(R, 0.3, B);
									}
									
									//// COLOR MATERIAL
									if (((COME_ModelJoint*)getGlobal())->rbMaterial->isChecked()){
										glColor3f(vertex.getColorMaterial().getX(),vertex.getColorMaterial().getY(),vertex.getColorMaterial().getZ());
									}
									
									//// COLOR COLLISION
									if (((COME_ModelJoint*)getGlobal())->rbCollision->isChecked()){
										glColor3f(vertex.getColor()[0],vertex.getColor()[1],vertex.getColor()[2]);
									}

									//// Exception colors
									/*if( ( (*iterOrgans)->getDescription() == "femurbone" ) || ( (*iterOrgans)->getDescription() == "pelvisbone" ) )
										glColor3f( 1.0,1.0, 1.0);
									if( ( (*iterOrgans)->getDescription() == "femurcart" ) || ( (*iterOrgans)->getDescription() == "pelviscart" ) )
										glColor3f( 0.8,0.8, 0.2);
									if( (*iterOrgans)->getDescription() == "labrum" )
										glColor3f( 0.7,0.7, 0.7);
									*/
									glTexCoord2f(vertex.getTexCoord().getX(),vertex.getTexCoord().getY());
									glVertex3d(vertex.x,vertex.y,vertex.z);
								}
							glEnd();
							/*for ( int j=0;j<3;j++){
								int indexVertex = faces[i].getIndexVertex(j); 
								COME_Vertex3D vertex = allVertices->at(indexVertex);
								//glPushMatrix();
								//	glTranslatef(vertex.pPlane.x,vertex.pPlane.y,vertex.pPlane.z);
								//	glutSolidSphere(0.05*((double)((COME_ModelJoint*)getGlobal())->sliderScale->value()/500.0), 8, 8);
								//glPopMatrix();

								if( vertex.getCollide() ) {
									glPushMatrix();
										glColor3f(1, 1, 1);
										glTranslatef( vertex.x,vertex.y,vertex.z );
										glutSolidSphere(0.02*((double)((COME_ModelJoint*)getGlobal())->sliderScale->value()/100.0), 15, 15);
									glPopMatrix();
								}
							}*/
							glDisable(GL_LIGHTING);
							if(((COME_ModelJoint*)getGlobal())->cbNormals->isChecked()){
								for ( int k=0;k<3;k++){
									int indexVertex = faces[i].getIndexVertex(k);
									COME_Vector3D normal = allVertices->at(indexVertex).getNormalGlobalPosition();
									COME_Vertex3D vertex = allVertices->at(indexVertex);
									glBegin(GL_LINES);
									glColor3f(1.0,1.0,1.0);
									glVertex3f(vertex.x,vertex.y,vertex.z);
									glVertex3f(vertex.x+(sceneRadius()/20.0*normal.x),vertex.y+(sceneRadius()/20.0*normal.y), vertex.z+(sceneRadius()/20.0*normal.z));
									glEnd();
								}
							}
							glEnable(GL_LIGHTING);
							
							/// uncoment to display collisions displacement when they exist
							if(((COME_ModelJoint*)getGlobal())->cbNormals->isChecked()){
								glDisable(GL_LIGHTING);
								for ( int k=0;k<3;k++){
									int indexVertex = faces[i].getIndexVertex(k); 
									COME_Vector3D normal = allVertices->at(indexVertex).getBlendedVelocity();//getCollisionDispAvg();
									COME_Vector3D velocity = allVertices->at(indexVertex).getVelocityDispAvg();
									COME_Vertex3D vertex = allVertices->at(indexVertex);
									glBegin(GL_LINES);
									glColor3f(0.1,0.1,0.1);
									glVertex3f(vertex.x,vertex.y,vertex.z);
									glVertex3f(vertex.x+normal.x,vertex.y+normal.y, vertex.z+normal.z);
									glEnd();
									glBegin(GL_LINES);
									glColor3f(1.0,1.0,1.0);
									glVertex3f(vertex.x,vertex.y,vertex.z);
									glVertex3f(vertex.x+velocity.x,vertex.y+velocity.y, vertex.z+velocity.z);
									glEnd();
								}
								glEnable(GL_LIGHTING);
							}
						}
					}
					if (((COME_ModelJoint*)getGlobal())->cbTexture->isChecked()){
						glDisable(GL_TEXTURE_2D);
					}
				}
				glPopName();
			}
		}

		scene->unlock();
		
		if (((COME_ModelJoint*)getGlobal())->cbMakeMovie->isChecked())
			if( oldClock < ((COME_ModelJoint*)getGlobal())->sim->getClock() ){
				saveSnapshot(true, true); // Warning, overwrite mode
				oldClock = ((COME_ModelJoint*)getGlobal())->sim->getClock();
			}
	}
	
}

void
COME_ModelJointQGLWidget::keyPressEvent(QKeyEvent *e){

  // Get event state key
  const Qt::ButtonState state = (Qt::ButtonState)(e->state() & Qt::KeyButtonMask);
  // Bug in Qt : use 0x0f00 instead of Qt::KeyButtonMask with Qt versions < 3.1

  // A simple switch on e->key() is not sufficient if we want to take state key into account.
  // With a switch, it would have been impossible to separate 'F' from 'CTRL+F'.
  // That's why we use imbricated if...else and a "handled" boolean.
  bool handled = false;
  switch( e->key() ){

  	case Qt::Key_Right:
		if(state==Qt::ShiftButton){
			((COME_ModelJoint*)getGlobal())->rotateSelected( 1, 0, 0 );
			handled = true;
		} else
		if(state==Qt::ControlButton){
			((COME_ModelJoint*)getGlobal())->translateSelected( 1, 0, 0 );
			handled = true;
		} else
		if(state==Qt::AltButton){
			((COME_ModelJoint*)getGlobal())->scaleSelected( 1, 0, 0 );
			handled = true;
		}
		break;
	case Qt::Key_Left:
		if(state==Qt::ShiftButton){
			((COME_ModelJoint*)getGlobal())->rotateSelected( -1, 0, 0 );
			handled = true;
		} else
		if(state==Qt::ControlButton){
			((COME_ModelJoint*)getGlobal())->translateSelected( -1, 0, 0 );
			handled = true;
		} else
		if(state==Qt::AltButton){
			((COME_ModelJoint*)getGlobal())->scaleSelected( -1, 0, 0 );
			handled = true;
		}
		break;
	case Qt::Key_Up:
		if(state==Qt::ShiftButton){
			((COME_ModelJoint*)getGlobal())->rotateSelected( 0, 1, 0 );
			handled = true;
		} else
		if(state==Qt::ControlButton){
			((COME_ModelJoint*)getGlobal())->translateSelected( 0, 1, 0 );
			handled = true;
		} else
		if(state==Qt::AltButton){
			((COME_ModelJoint*)getGlobal())->scaleSelected( 0, 1, 0 );
			handled = true;
		}
		break;
	case Qt::Key_Down:
		if(state==Qt::ShiftButton){
			((COME_ModelJoint*)getGlobal())->rotateSelected( 0, -1, 0 );
			handled = true;
		} else
		if(state==Qt::ControlButton){
			((COME_ModelJoint*)getGlobal())->translateSelected( 0, -1, 0 );
			handled = true;
		} else
		if(state==Qt::AltButton){
			((COME_ModelJoint*)getGlobal())->scaleSelected( 0, -1, 0 );
			handled = true;
		}
		break;
	case Qt::Key_PageUp:
		if(state==Qt::ShiftButton){
			((COME_ModelJoint*)getGlobal())->rotateSelected( 0, 0, 1 );
			handled = true;
		} else
		if(state==Qt::ControlButton){
			((COME_ModelJoint*)getGlobal())->translateSelected( 0, 0, 1 );
			handled = true;
		} else
		if(state==Qt::AltButton){
			((COME_ModelJoint*)getGlobal())->scaleSelected( 0, 0, 1 );
			handled = true;
		}
		break;
	case Qt::Key_PageDown:
		if(state==Qt::ShiftButton){
			((COME_ModelJoint*)getGlobal())->rotateSelected( 0, 0, -1 );
			handled = true;
		} else
		if(state==Qt::ControlButton){
			((COME_ModelJoint*)getGlobal())->translateSelected( 0, 0, -1 );
			handled = true;
		} else
		if(state==Qt::AltButton){
			((COME_ModelJoint*)getGlobal())->scaleSelected( 0, 0, -1 );
			handled = true;
		}
		break;
  }

	if (!handled){
		COME_QGLWidget::keyPressEvent(e);
	} else {
		updateGL();
	}
}

void
COME_ModelJointQGLWidget::postSelection(const QPoint& point){

	if( selectedName() == -1 )
	{
		// Unselect all if no object is selected.
		scene->getPatient(0)->unselectAll();
		((COME_ModelJoint*)getGlobal())->statusBar()->message( "No object selected.", 1000 );
	}
	else {
		
		if( scene->getPatient(0)->getOrgan( selectedName() ) ){
			char chMessage[30];
			sprintf( chMessage, "Object %d selected in patient 0.", selectedName() );
			((COME_ModelJoint*)getGlobal())->statusBar()->message( chMessage, 1000 );
			scene->getPatient(0)->unselectAll();
			scene->getPatient(0)->getOrgan( selectedName() )->select(true);
		}
	}

}

void
COME_ModelJointQGLWidget::drawWithNames(){

	draw();
}


void
COME_ModelJointQGLWidget::loadTextures() {
  
	for( int iP = 0; iP < scene->getPatientList()->size(); iP++ ){
		//Main loop: For each organ display the object
		list<COME_BioStructure*>::const_iterator iterOrgans;
		
		for( iterOrgans = ((list<COME_BioStructure *>*)scene->getPatient(iP)->getPtOrganList())->begin(); iterOrgans != ((list<COME_BioStructure *>*)scene->getPatient(iP)->getPtOrganList())->end(); iterOrgans++  ){
		
			COME_Mesh* currMesh = (*iterOrgans)->getPointerToSurface();
			
			if( ( currMesh ) && ( currMesh->getTexture() ) ){
	
				// Create Texture	
				glGenTextures(1, currMesh->getTextureID() );
				glBindTexture(GL_TEXTURE_2D, *(currMesh->getTextureID()) );   // 2d texture (x and y size)
				
				glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR); // scale linearly when image bigger than texture
				glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR); // scale linearly when image smalled than texture
				
				// 2d texture, level of detail 0 (normal), 3 components (red, green, blue), x size from image, y size from image, 
				// border 0 (normal), rgb color data, unsigned byte data, and finally the data itself.
				glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, currMesh->getTexture()->sizeX, currMesh->getTexture()->sizeY, 0, GL_RGB, GL_UNSIGNED_BYTE, currMesh->getTexture()->data);
			}
		}
	}
}

void
COME_ModelJointQGLWidget::init(){

	//loadTextures();
	COME_QGLWidget::init();
}
