/***************************************************************************
 *   Copyright (C) 2004 by Anderson Maciel                                 *
 *   andi.maciel@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/
#include "comemodeljoint.h"
#include <qfiledialog.h>
#include <qspinbox.h>
#include <qcursor.h>
#include <qstatusbar.h>
#include <qtable.h>
#include <qlistbox.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qtabwidget.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qslider.h>
#include <qpushbutton.h>
#include <come_modeljointqglwidget.h>
#include <dlgnewmaterial.h>
#include <general/come.h>
#include <general/comesimulator.h>
#include <general/comescenario.h>
//#include <general/comexml.h>
#include <bio/comemoleculescartilage.h>
#include <bio/comematerial.h>
#include <physics/comecollide.h>
#include <algorithm>
#include <qtl.h>

using namespace std;

COME_ModelJoint::COME_ModelJoint()
 : modeljoint(){
 
	scene = new COME_Scenario();
	sim = new COME_Simulator();
	sim->setScene( scene );
	molecFixSelected = molecMobileSelected = NULL;
	
	openglArea->setScene( scene );
	openglArea->setGlobal( (COME*)this );
}


COME_ModelJoint::~COME_ModelJoint(){

	delete scene;
	delete sim;
}

void
COME_ModelJoint::fileOpen(){
/*
	QString fileName = QFileDialog::getOpenFileName(
                    ".",
                    "Organ files (*.xml)",
                    this,
                    "open file dialog"
                    "Choose a file" );
	if( !fileName.isEmpty() ){
	
		QString folderName = fileName;
		folderName.truncate( folderName.findRev( "/" ) );
		COME::baseFolder = folderName.latin1();
	
		QString msg = "Loading ";
		statusBar()->message( msg + fileName );
		hourglass(true);
		scene->addOrganFromFile( fileName.latin1(), sim );
		openglArea->loadTextures();
		statusBar()->message( "Loaded.", 2000 );
		hourglass(false);
	}
*/
	fileLoad_scene();
}

void
 COME_ModelJoint::loadFileIfArguments( int argc, char ** argv ){
 
	if( ( argc > 1 ) && ( argc < 3 ) ){
		printf("Usage: modeljoint [input_file] [output_file]\n" );
	} else if( argc == 3 ){
		default_output_file = argv[2];
		QString fileName = argv[1];
		if( !fileName.isEmpty() ){

			QString folderName = fileName;
			folderName.truncate( folderName.findRev( "/" ) );
			COME::baseFolder = folderName.latin1();
			
			QString msg = "Loading scene from ";
			statusBar()->message( msg + fileName );
			hourglass(true);
			scene->loadFile( fileName.latin1(), sim );
			scene->setDescription( fileName.latin1() );
			statusBar()->message( "Loaded.", 2000 );
			openglArea->loadTextures();
			
			// Set scene radius for view
			double sceneRadius = 0.01;
			COME_Point3D mins, maxs;
			for( int iP = 0; iP < scene->getPatientList()->size(); iP++ ){
			list<COME_BioStructure*>::const_iterator iterOrgans;
				for( iterOrgans = ((list<COME_BioStructure *>*)scene->getPatient(iP)->getPtOrganList())->begin(); iterOrgans != ((list<COME_BioStructure *>*)scene->getPatient(iP)->getPtOrganList())->end(); iterOrgans++  ){
					
					if( (*iterOrgans)->getSurface() ){
						(*iterOrgans)->getSurface()->getEnvelop( mins, maxs );
						sceneRadius = fabs( mins.vpDistance( COME_Point3D(0,0,0) ) ) > sceneRadius ? fabs( mins.vpDistance( COME_Point3D(0,0,0) ) ) : sceneRadius;
						sceneRadius = fabs( maxs.vpDistance( COME_Point3D(0,0,0) ) ) > sceneRadius ? fabs( maxs.vpDistance( COME_Point3D(0,0,0) ) ) : sceneRadius;
					}
					(*iterOrgans)->getEnvelop( mins, maxs );
					sceneRadius = fabs( mins.vpDistance( COME_Point3D(0,0,0) ) ) > sceneRadius ? fabs( mins.vpDistance( COME_Point3D(0,0,0) ) ) : sceneRadius;
					sceneRadius = fabs( maxs.vpDistance( COME_Point3D(0,0,0) ) ) > sceneRadius ? fabs( maxs.vpDistance( COME_Point3D(0,0,0) ) ) : sceneRadius;
				}
			}
			openglArea->setSceneRadius( sceneRadius + sceneRadius*0.1 );
			openglArea->camera()->showEntireScene();
			
			if( COME::flagCollisionTreatment == NEIGHBORS ){
				scene->getCollisionDetector()->initializeProximityStructure();
			}
			
			hourglass(false);
		}

	}

 }

void
COME_ModelJoint::fileLoad_scene(){

	QString fileName = QFileDialog::getOpenFileName(
                    ".",
                    "Scene files (*.xml)",
                    this,
                    "open file dialog"
                    "Choose a file" );
	if( !fileName.isEmpty() ){
	
		QString folderName = fileName;
		folderName.truncate( folderName.findRev( "/" ) );
		COME::baseFolder = folderName.latin1();
		
		QString msg = "Loading scene from ";
		statusBar()->message( msg + fileName );
		hourglass(true);
		scene->loadFile( fileName.latin1(), sim );
		scene->setDescription( fileName.latin1() );
		statusBar()->message( "Loaded.", 2000 );
		openglArea->loadTextures();
		
		// Set scene radius for view
		double sceneRadius = 0.01;
		COME_Point3D mins, maxs;
		for( int iP = 0; iP < scene->getPatientList()->size(); iP++ ){
		list<COME_BioStructure*>::const_iterator iterOrgans;
			for( iterOrgans = ((list<COME_BioStructure *>*)scene->getPatient(iP)->getPtOrganList())->begin(); iterOrgans != ((list<COME_BioStructure *>*)scene->getPatient(iP)->getPtOrganList())->end(); iterOrgans++  ){
				
				if( (*iterOrgans)->getSurface() ){
					(*iterOrgans)->getSurface()->getEnvelop( mins, maxs );
					sceneRadius = fabs( mins.vpDistance( COME_Point3D(0,0,0) ) ) > sceneRadius ? fabs( mins.vpDistance( COME_Point3D(0,0,0) ) ) : sceneRadius;
					sceneRadius = fabs( maxs.vpDistance( COME_Point3D(0,0,0) ) ) > sceneRadius ? fabs( maxs.vpDistance( COME_Point3D(0,0,0) ) ) : sceneRadius;
				}
				(*iterOrgans)->getEnvelop( mins, maxs );
				sceneRadius = fabs( mins.vpDistance( COME_Point3D(0,0,0) ) ) > sceneRadius ? fabs( mins.vpDistance( COME_Point3D(0,0,0) ) ) : sceneRadius;
				sceneRadius = fabs( maxs.vpDistance( COME_Point3D(0,0,0) ) ) > sceneRadius ? fabs( maxs.vpDistance( COME_Point3D(0,0,0) ) ) : sceneRadius;
			}
		}
		openglArea->setSceneRadius( sceneRadius + sceneRadius*0.1 );
		openglArea->camera()->showEntireScene();
		
		if( COME::flagCollisionTreatment == NEIGHBORS ){
			scene->getCollisionDetector()->initializeProximityStructure();
		}
		
		hourglass(false);
	}
}


void
COME_ModelJoint::fileExportAs(){

	QString fileName;
	QFileDialog* fd = new QFileDialog( this, "save as dialog", TRUE );
	fd->setCaption( "Export molecules file as...");
	fd->setMode( QFileDialog::AnyFile );
	fd->setFilter( "Molecules (*.xml)" );
	if( default_output_file != "" )
		fd->setSelection( default_output_file.c_str() );
	
	if ( fd->exec() == QDialog::Accepted ){
		hourglass(true);
		fileName = fd->selectedFile();
		printf( "Saving %s... ", fileName.latin1() );
		scene->saveFile( fileName.latin1(), sim );
		printf( " saved.\n" );
		hourglass(false);
	}
}

void
COME_ModelJoint::rotateSelected( int rx, int ry, int rz ){

	if( scene->getPatient(0)->getSelected() ){
		double step = sbStepRotate->value() * M_PI / 180.0;
		scene->getPatient(0)->getSelected()->rotate( rx*step, ry*step, rz*step );
	}
}

void
COME_ModelJoint::translateSelected( int dx, int dy, int dz ){

	if( scene->getPatient(0)->getSelected() ){
		double step = sbStepTranslate->value() * (openglArea->sceneRadius()/(double)openglArea->width());
		scene->getPatient(0)->getSelected()->translate( dx*step, dy*step, dz*step );
		//printf(" %f %f %f \n", dx*step, dy*step, dz*step );
	}
}

void
COME_ModelJoint::scaleSelected( int fx, int fy, int fz ){

	if( scene->getPatient(0)->getSelected() ){
		double step = ( (fx+fy+fz) > 0.0
				? sbStepScale->value() / 100.0
				: 1.0 - (sbStepScale->value() % 100) / 100.0);
		scene->getPatient(0)->getSelected()->scale( fx==0?1.0:step, fy==0?1.0:step, fz==0?1.0:step );
	}
}

void
COME_ModelJoint::clickedStartSim(){

	// Simulate physics here to perform the test
	sim->setDuration( atof(leFadeInForce->text()) + atof(leKeepForce->text()) + atof(leFadeOutForce->text()) );
	sim->setFPS( sbFPS->value() );
	bpStartForce->setDown( true );
	sim->start();

}

void
COME_ModelJoint::pauseSim(){

	// Pause simulation
	if( !sim->getPause() ){
		pbPause->setDown( true );
		sim->setPause( true );
	} else {
		pbPause->setDown( false );
		sim->setPause( false );
	}
}

void
COME_ModelJoint::fpsChange(){

	char chrStr[10];
	sprintf( chrStr, "%1.6f", 1.0/(double)sbFPS->value() );
	leTimeStep->setText( chrStr );
	sim->setDuration( atof(leFadeInForce->text()) + atof(leKeepForce->text()) + atof(leFadeOutForce->text()) );
	sim->setFPS( sbFPS->value() );
}

void
COME_ModelJoint::durationChange(){
	
	sim->setDuration( atof(leFadeInForce->text()) + atof(leKeepForce->text()) + atof(leFadeOutForce->text()) );
}

void
COME_ModelJoint::changedCollisionTreatment(){

	char chrType[100];
	switch( cbCollisionTreatment->currentItem() ){
		case 0: COME::flagCollisionTreatment = SPHERES; strcpy(chrType,"Collision treatment is now set to use SPHERES.");break;
		case 1: COME::flagCollisionTreatment = MESH; strcpy(chrType,"Collision treatment is now set to use MESHES."); break;
		case 2: COME::flagCollisionTreatment = HYBRID; strcpy(chrType,"Collision treatment is now set to use MESHES for detection and SPHERES for force calculation."); break;
		case 3: COME::flagCollisionTreatment = DISPLACEMENT; strcpy(chrType,"Collision treatment is now set to displacement fields."); break;
		case 4: COME::flagCollisionTreatment = NO_COLLISION; strcpy(chrType,"No collision treatment."); break;
		case 5: COME::flagCollisionTreatment = NEIGHBORS; scene->getCollisionDetector()->initializeProximityStructure(); strcpy(chrType,"Using neighbors and prediction for collision treatment."); break;
		case 6: COME::flagCollisionTreatment = SPHERICAL_SLIDING; scene->initializeAllHashs(); strcpy(chrType,"Using spherical sliding for collision treatment."); break;
	}
	QString msg = chrType;
	statusBar()->message( msg, 2000 );
}

void
COME_ModelJoint::changed2ndPass(){

	char chrType[100];

	COME::flagCollision2ndPass = cb2ndPass->isChecked();
	strcpy(chrType,"Apply checking vertices near to collisions for completely immerged faces.");
	QString msg = chrType;
	statusBar()->message( msg, 2000 );
}

void
COME_ModelJoint::changedNumIntegration(){

	char chrType[60];
	switch( cbNumIntegration->currentItem() ){
		case 0: COME::flagNumIntegration = EULER; strcpy(chrType,"Numerical integration method is now Euler.");break;
		case 1: COME::flagNumIntegration = RUNGE_KUTTA4; strcpy(chrType,"Numerical integration method is now Runge-Kutta 4."); break;
	}
	QString msg = chrType;
	statusBar()->message( msg, 2000 );
}

void
COME_ModelJoint::exportPrecalculationChanged(){

	COME::flagExportToPrecalculatedFile = cbExportPrecalculation->isChecked();
	
	if( COME::flagExportToPrecalculatedFile ){
	
		tlAnimationResolution->setEnabled(true);
		leAnimationResolution->setEnabled(true);
		
		if( atof( leTimeStep->text() ) < atof( leAnimationResolution->text() ) ){
			leAnimationResolution->setText( leTimeStep->text() );
			animationResolutionChanged();
		}
		
		// for all deformable
		scene->createPrecalculatedFiles();
		
		// this must be used by the player application
		//((COME_MoleculesCartilage*)tempOrgan)->getTissue()->loadDeformationFile( fileDeformation );
			
		sim->setType( OFFLINE );
		
		// this must be used by the player application
		//simulator->setType( ONLINE );
	} else {
		tlAnimationResolution->setEnabled(false);
		leAnimationResolution->setEnabled(false);
	}
}

void
COME_ModelJoint::animationResolutionChanged(){

	COME::flagAnimationResolution = atof( leAnimationResolution->text() );
}

void
COME_ModelJoint::sliderNominalReleased(){

	char chrType[60];
	
	if( scene->getPatient(0)->getSelected() ){
		
		scene->getPatient(0)->getSelected()->scaleNominals( 1.0 - ( ((float)(sliderNominal->value())) / 100.0 ) );
	}
	
	strcpy(chrType,"Nominal distances changed for the selected object.");
	QString msg = chrType;
	statusBar()->message( msg, 2000 );
}

void
COME_ModelJoint::hourglass( bool yesno ){

	if( yesno ){
		setCursor( Qt::WaitCursor );
		openglArea->setCursor( Qt::WaitCursor );
	} else {
		setCursor( Qt::ArrowCursor );
		openglArea->setCursor( Qt::ArrowCursor );
	}
}
