//lighting per vertex
void main() {
	
	vec3 normal, lightDir;
	vec4 diffuse, ambient, globalAmbient, specular;
	float NdotL, NdotHV;
	
	/* primeiro transforma a normal para o sistema da camera e normaliza o resultado */
	normal = normalize(gl_NormalMatrix * gl_Normal);
	
	/* agora normaliza a direo da luz. Lembre-se de que de acordo com a
	especificacao da OpenGL, a luz eh armazenada no sistema da camera. Lembre-se tambm que 
	estamos falando de luz direcional. Assim, o campo position eh na verdade a direcao.*/
	lightDir = normalize(vec3(gl_LightSource[0].position));
	
	/* computa o cosseno do angulo entre a normal e a luz. 
	Como a luz eh direcional, a direcao eh constante para todos os vertices.
	Como as duas estao normalizadas, o cosseno eh o produto escalar. Tambem precisamos 
	limitar o resultado ao intervalo [0,1]. */
	NdotL = max(dot(normal, lightDir), 0.0);
	
	/* computa o termo difuso */
	diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;
	
	/* Computa o termo ambiente e ambiente global */
	ambient = gl_FrontMaterial.ambient * gl_LightSource[0].ambient;
	globalAmbient = gl_LightModel.ambient * gl_FrontMaterial.ambient;
	
	/* computa o termo especular se NdotL eh maior que zero */
	if (NdotL > 0.0) {
	
		// normaliza o vetor-meio, e entao computa o 
		// cosseno (produto escalar) com a normal
		NdotHV = max(dot(normal, gl_LightSource[0].halfVector.xyz),0.0);
		specular = gl_FrontMaterial.specular * gl_LightSource[0].specular * 
				pow(NdotHV,gl_FrontMaterial.shininess);
	}

	
	gl_FrontColor =  NdotL * diffuse + globalAmbient + ambient + specular;
	
	gl_Position = ftransform();
}
